// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/completion_service.proto

#include "google/cloud/retail/completion_connection.h"
#include "google/cloud/retail/completion_options.h"
#include "google/cloud/retail/internal/completion_connection_impl.h"
#include "google/cloud/retail/internal/completion_option_defaults.h"
#include "google/cloud/retail/internal/completion_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CompletionServiceConnection::~CompletionServiceConnection() = default;

StatusOr<google::cloud::retail::v2::CompleteQueryResponse>
CompletionServiceConnection::CompleteQuery(
    google::cloud::retail::v2::CompleteQueryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::retail::v2::ImportCompletionDataResponse>>
CompletionServiceConnection::ImportCompletionData(
    google::cloud::retail::v2::ImportCompletionDataRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::retail::v2::ImportCompletionDataResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<CompletionServiceConnection> MakeCompletionServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 CompletionServicePolicyOptionList>(options,
                                                                    __func__);
  options =
      retail_internal::CompletionServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = retail_internal::CreateDefaultCompletionServiceStub(
      background->cq(), options);
  return std::make_shared<retail_internal::CompletionServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace retail_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<retail::CompletionServiceConnection>
MakeCompletionServiceConnection(std::shared_ptr<CompletionServiceStub> stub,
                                Options options) {
  options = CompletionServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<retail_internal::CompletionServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_internal
}  // namespace cloud
}  // namespace google
