// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#include "google/cloud/retail/catalog_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CatalogServiceConnectionIdempotencyPolicy::
    ~CatalogServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultCatalogServiceConnectionIdempotencyPolicy
    : public CatalogServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultCatalogServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<CatalogServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultCatalogServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListCatalogs(
      google::cloud::retail::v2::ListCatalogsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateCatalog(
      google::cloud::retail::v2::UpdateCatalogRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetDefaultBranch(
      google::cloud::retail::v2::SetDefaultBranchRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetDefaultBranch(
      google::cloud::retail::v2::GetDefaultBranchRequest const&) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<CatalogServiceConnectionIdempotencyPolicy>
MakeDefaultCatalogServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultCatalogServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail
}  // namespace cloud
}  // namespace google
