// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#include "google/cloud/retail/catalog_connection.h"
#include "google/cloud/retail/catalog_options.h"
#include "google/cloud/retail/internal/catalog_connection_impl.h"
#include "google/cloud/retail/internal/catalog_option_defaults.h"
#include "google/cloud/retail/internal/catalog_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CatalogServiceConnection::~CatalogServiceConnection() = default;

StreamRange<google::cloud::retail::v2::Catalog>
CatalogServiceConnection::ListCatalogs(
    google::cloud::retail::v2::ListCatalogsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::retail::v2::Catalog>>(
      std::move(request),
      [](google::cloud::retail::v2::ListCatalogsRequest const&) {
        return StatusOr<google::cloud::retail::v2::ListCatalogsResponse>{};
      },
      [](google::cloud::retail::v2::ListCatalogsResponse const&) {
        return std::vector<google::cloud::retail::v2::Catalog>();
      });
}

StatusOr<google::cloud::retail::v2::Catalog>
CatalogServiceConnection::UpdateCatalog(
    google::cloud::retail::v2::UpdateCatalogRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status CatalogServiceConnection::SetDefaultBranch(
    google::cloud::retail::v2::SetDefaultBranchRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
CatalogServiceConnection::GetDefaultBranch(
    google::cloud::retail::v2::GetDefaultBranchRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<CatalogServiceConnection> MakeCatalogServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 CatalogServicePolicyOptionList>(options,
                                                                 __func__);
  options = retail_internal::CatalogServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = retail_internal::CreateDefaultCatalogServiceStub(background->cq(),
                                                               options);
  return std::make_shared<retail_internal::CatalogServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace retail_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<retail::CatalogServiceConnection> MakeCatalogServiceConnection(
    std::shared_ptr<CatalogServiceStub> stub, Options options) {
  options = CatalogServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<retail_internal::CatalogServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_internal
}  // namespace cloud
}  // namespace google
