// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/projects.proto

#include "google/cloud/resourcemanager/projects_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ProjectsConnectionIdempotencyPolicy::~ProjectsConnectionIdempotencyPolicy() =
    default;

namespace {
class DefaultProjectsConnectionIdempotencyPolicy
    : public ProjectsConnectionIdempotencyPolicy {
 public:
  ~DefaultProjectsConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ProjectsConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultProjectsConnectionIdempotencyPolicy>(*this);
  }

  Idempotency GetProject(
      google::cloud::resourcemanager::v3::GetProjectRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListProjects(
      google::cloud::resourcemanager::v3::ListProjectsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency SearchProjects(
      google::cloud::resourcemanager::v3::SearchProjectsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateProject(
      google::cloud::resourcemanager::v3::CreateProjectRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateProject(
      google::cloud::resourcemanager::v3::UpdateProjectRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency MoveProject(
      google::cloud::resourcemanager::v3::MoveProjectRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteProject(
      google::cloud::resourcemanager::v3::DeleteProjectRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UndeleteProject(
      google::cloud::resourcemanager::v3::UndeleteProjectRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ProjectsConnectionIdempotencyPolicy>
MakeDefaultProjectsConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultProjectsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager
}  // namespace cloud
}  // namespace google
