// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/projects.proto

#include "google/cloud/resourcemanager/projects_connection.h"
#include "google/cloud/resourcemanager/internal/projects_connection_impl.h"
#include "google/cloud/resourcemanager/internal/projects_option_defaults.h"
#include "google/cloud/resourcemanager/internal/projects_stub_factory.h"
#include "google/cloud/resourcemanager/projects_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProjectsConnection::~ProjectsConnection() = default;

StatusOr<google::cloud::resourcemanager::v3::Project>
ProjectsConnection::GetProject(
    google::cloud::resourcemanager::v3::GetProjectRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::resourcemanager::v3::Project>
ProjectsConnection::ListProjects(
    google::cloud::resourcemanager::v3::ListProjectsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Project>>(
      std::move(request),
      [](google::cloud::resourcemanager::v3::ListProjectsRequest const&) {
        return StatusOr<
            google::cloud::resourcemanager::v3::ListProjectsResponse>{};
      },
      [](google::cloud::resourcemanager::v3::ListProjectsResponse const&) {
        return std::vector<google::cloud::resourcemanager::v3::Project>();
      });
}

StreamRange<google::cloud::resourcemanager::v3::Project>
ProjectsConnection::SearchProjects(
    google::cloud::resourcemanager::v3::SearchProjectsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Project>>(
      std::move(request),
      [](google::cloud::resourcemanager::v3::SearchProjectsRequest const&) {
        return StatusOr<
            google::cloud::resourcemanager::v3::SearchProjectsResponse>{};
      },
      [](google::cloud::resourcemanager::v3::SearchProjectsResponse const&) {
        return std::vector<google::cloud::resourcemanager::v3::Project>();
      });
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::CreateProject(
    google::cloud::resourcemanager::v3::CreateProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::UpdateProject(
    google::cloud::resourcemanager::v3::UpdateProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::MoveProject(
    google::cloud::resourcemanager::v3::MoveProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::DeleteProject(
    google::cloud::resourcemanager::v3::DeleteProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::UndeleteProject(
    google::cloud::resourcemanager::v3::UndeleteProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::iam::v1::Policy> ProjectsConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ProjectsConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ProjectsConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ProjectsConnection> MakeProjectsConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 ProjectsPolicyOptionList>(options, __func__);
  options =
      resourcemanager_internal::ProjectsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = resourcemanager_internal::CreateDefaultProjectsStub(
      background->cq(), options);
  return std::make_shared<resourcemanager_internal::ProjectsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace resourcemanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<resourcemanager::ProjectsConnection> MakeProjectsConnection(
    std::shared_ptr<ProjectsStub> stub, Options options) {
  options = ProjectsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<resourcemanager_internal::ProjectsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_internal
}  // namespace cloud
}  // namespace google
