// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/projects.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_PROJECTS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_PROJECTS_CLIENT_H

#include "google/cloud/resourcemanager/projects_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages Google Cloud Projects.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ProjectsClient {
 public:
  explicit ProjectsClient(std::shared_ptr<ProjectsConnection> connection,
                          Options options = {});
  ~ProjectsClient();

  //@{
  // @name Copy and move support
  ProjectsClient(ProjectsClient const&) = default;
  ProjectsClient& operator=(ProjectsClient const&) = default;
  ProjectsClient(ProjectsClient&&) = default;
  ProjectsClient& operator=(ProjectsClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ProjectsClient const& a, ProjectsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ProjectsClient const& a, ProjectsClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Retrieves the project identified by the specified `name` (for example,
  /// `projects/415104041262`).
  ///
  /// The caller must have `resourcemanager.projects.get` permission
  /// for this project.
  ///
  /// @param name  Required. The name of the project (for example,
  /// `projects/415104041262`).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.GetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L373}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  StatusOr<google::cloud::resourcemanager::v3::Project> GetProject(
      std::string const& name, Options options = {});

  ///
  /// Retrieves the project identified by the specified `name` (for example,
  /// `projects/415104041262`).
  ///
  /// The caller must have `resourcemanager.projects.get` permission
  /// for this project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::GetProjectRequest,google/cloud/resourcemanager/v3/projects.proto#L373}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.GetProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L373}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  StatusOr<google::cloud::resourcemanager::v3::Project> GetProject(
      google::cloud::resourcemanager::v3::GetProjectRequest const& request,
      Options options = {});

  ///
  /// Lists projects that are direct children of the specified folder or
  /// organization resource. `list()` provides a strongly consistent view of the
  /// projects underneath the specified parent resource. `list()` returns
  /// projects sorted based upon the (ascending) lexical ordering of their
  /// `display_name`. The caller must have `resourcemanager.projects.list`
  /// permission on the identified parent.
  ///
  /// @param parent  Required. The name of the parent resource to list projects
  /// under.
  ///  For example, setting this field to 'folders/1234' would list all projects
  ///  directly under that folder.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.ListProjectsRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L386}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  StreamRange<google::cloud::resourcemanager::v3::Project> ListProjects(
      std::string const& parent, Options options = {});

  ///
  /// Lists projects that are direct children of the specified folder or
  /// organization resource. `list()` provides a strongly consistent view of the
  /// projects underneath the specified parent resource. `list()` returns
  /// projects sorted based upon the (ascending) lexical ordering of their
  /// `display_name`. The caller must have `resourcemanager.projects.list`
  /// permission on the identified parent.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::ListProjectsRequest,google/cloud/resourcemanager/v3/projects.proto#L386}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.ListProjectsRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L386}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  StreamRange<google::cloud::resourcemanager::v3::Project> ListProjects(
      google::cloud::resourcemanager::v3::ListProjectsRequest request,
      Options options = {});

  ///
  /// Search for projects that the caller has both
  /// `resourcemanager.projects.get` permission on, and also satisfy the
  /// specified query.
  ///
  /// This method returns projects in an unspecified order.
  ///
  /// This method is eventually consistent with project mutations; this means
  /// that a newly created project may not appear in the results or recent
  /// updates to an existing project may not be reflected in the results. To
  /// retrieve the latest state of a project, use the
  /// [GetProject][google.cloud.resourcemanager.v3.Projects.GetProject] method.
  ///
  /// @param query  Optional. A query string for searching for projects that the
  /// caller has
  ///  `resourcemanager.projects.get` permission to. If multiple fields are
  ///  included in the query, the it will return results that match any of the
  ///  fields. Some eligible fields are:
  ///  ```
  ///  | Field                   | Description |
  ///  |-------------------------|----------------------------------------------|
  ///  | displayName, name       | Filters by displayName. | | parent |
  ///  Project's parent. (for example: folders/123, organizations/*) Prefer
  ///  parent field over parent.type and parent.id. | | parent.type | Parent's
  ///  type: `folder` or `organization`.   | | parent.id               |
  ///  Parent's id number (for example: 123)        | | id, projectId | Filters
  ///  by projectId.                        | | state, lifecycleState   |
  ///  Filters by state.                            | | labels | Filters by
  ///  label name or value.              | | labels.<key> (where *key* is the
  ///  name of a label) | Filters by label name. |
  ///  ```
  ///  Search expressions are case insensitive.
  ///  Some examples queries:
  ///  ```
  ///  | Query            | Description |
  ///  |------------------|-----------------------------------------------------|
  ///  | name:how*        | The project's name starts with "how". | | name:Howl
  ///  | The project's name is `Howl` or `howl`.             | | name:HOWL |
  ///  Equivalent to above.                                | | NAME:howl |
  ///  Equivalent to above.                                | | labels.color:* |
  ///  The project has the label `color`.                  | | labels.color:red
  ///  | The project's label `color` has the value `red`.    | |
  ///  labels.color:red&nbsp;labels.size:big | The project's label `color` has
  ///  the value `red` and its label `size` has the value `big`. |
  ///  ```
  ///  If no query is specified, the call will return projects for which the
  ///  user has the `resourcemanager.projects.get` permission.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.SearchProjectsRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L444}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  StreamRange<google::cloud::resourcemanager::v3::Project> SearchProjects(
      std::string const& query, Options options = {});

  ///
  /// Search for projects that the caller has both
  /// `resourcemanager.projects.get` permission on, and also satisfy the
  /// specified query.
  ///
  /// This method returns projects in an unspecified order.
  ///
  /// This method is eventually consistent with project mutations; this means
  /// that a newly created project may not appear in the results or recent
  /// updates to an existing project may not be reflected in the results. To
  /// retrieve the latest state of a project, use the
  /// [GetProject][google.cloud.resourcemanager.v3.Projects.GetProject] method.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::SearchProjectsRequest,google/cloud/resourcemanager/v3/projects.proto#L444}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.SearchProjectsRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L444}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  StreamRange<google::cloud::resourcemanager::v3::Project> SearchProjects(
      google::cloud::resourcemanager::v3::SearchProjectsRequest request,
      Options options = {});

  ///
  /// Request that a new project be created. The result is an `Operation` which
  /// can be used to track the creation process. This process usually takes a
  /// few seconds, but can sometimes take much longer. The tracking `Operation`
  /// is automatically deleted after a few hours, so there is no need to call
  /// `DeleteOperation`.
  ///
  /// @param project  Required. The Project to create.
  ///  Project ID is required. If the requested ID is unavailable, the request
  ///  fails.
  ///  If the `parent` field is set, the `resourcemanager.projects.create`
  ///  permission is checked on the parent resource. If no parent is set and
  ///  the authorization credentials belong to an Organziation, the parent
  ///  will be set to that Organization.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.CreateProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L526}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> CreateProject(
      google::cloud::resourcemanager::v3::Project const& project,
      Options options = {});

  ///
  /// Request that a new project be created. The result is an `Operation` which
  /// can be used to track the creation process. This process usually takes a
  /// few seconds, but can sometimes take much longer. The tracking `Operation`
  /// is automatically deleted after a few hours, so there is no need to call
  /// `DeleteOperation`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::CreateProjectRequest,google/cloud/resourcemanager/v3/projects.proto#L526}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.CreateProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L526}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> CreateProject(
      google::cloud::resourcemanager::v3::CreateProjectRequest const& request,
      Options options = {});

  ///
  /// Updates the `display_name` and labels of the project identified by the
  /// specified `name` (for example, `projects/415104041262`). Deleting all
  /// labels requires an update mask for labels field.
  ///
  /// The caller must have `resourcemanager.projects.update` permission for this
  /// project.
  ///
  /// @param project  Required. The new definition of the project.
  /// @param update_mask  Optional. An update mask to selectively update fields.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.UpdateProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L562}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UpdateProject(
      google::cloud::resourcemanager::v3::Project const& project,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the `display_name` and labels of the project identified by the
  /// specified `name` (for example, `projects/415104041262`). Deleting all
  /// labels requires an update mask for labels field.
  ///
  /// The caller must have `resourcemanager.projects.update` permission for this
  /// project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::UpdateProjectRequest,google/cloud/resourcemanager/v3/projects.proto#L562}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.UpdateProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L562}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UpdateProject(
      google::cloud::resourcemanager::v3::UpdateProjectRequest const& request,
      Options options = {});

  ///
  /// Move a project to another place in your resource hierarchy, under a new
  /// resource parent.
  ///
  /// Returns an operation which can be used to track the process of the project
  /// move workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// moved project.
  ///
  /// The caller must have `resourcemanager.projects.update` permission on the
  /// project and have `resourcemanager.projects.move` permission on the
  /// project's current and proposed new parent.
  ///
  ///
  ///
  /// @param name  Required. The name of the project to move.
  /// @param destination_parent  Required. The new parent to move the Project
  /// under.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.MoveProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L579}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> MoveProject(
      std::string const& name, std::string const& destination_parent,
      Options options = {});

  ///
  /// Move a project to another place in your resource hierarchy, under a new
  /// resource parent.
  ///
  /// Returns an operation which can be used to track the process of the project
  /// move workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// moved project.
  ///
  /// The caller must have `resourcemanager.projects.update` permission on the
  /// project and have `resourcemanager.projects.move` permission on the
  /// project's current and proposed new parent.
  ///
  ///
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::MoveProjectRequest,google/cloud/resourcemanager/v3/projects.proto#L579}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.MoveProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L579}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> MoveProject(
      google::cloud::resourcemanager::v3::MoveProjectRequest const& request,
      Options options = {});

  ///
  /// Marks the project identified by the specified
  /// `name` (for example, `projects/415104041262`) for deletion.
  ///
  /// This method will only affect the project if it has a lifecycle state of
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE].
  ///
  /// This method changes the Project's lifecycle state from
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE]
  /// to
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED].
  /// The deletion starts at an unspecified time,
  /// at which point the Project is no longer accessible.
  ///
  /// Until the deletion completes, you can check the lifecycle state
  /// checked by retrieving the project with [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// and the project remains visible to [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects].
  /// However, you cannot update the project.
  ///
  /// After the deletion completes, the project is not retrievable by
  /// the  [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects], and
  /// [SearchProjects][google.cloud.resourcemanager.v3.Projects.SearchProjects]
  /// methods.
  ///
  /// This method behaves idempotently, such that deleting a `DELETE_REQUESTED`
  /// project will not cause an error, but also won't do anything.
  ///
  /// The caller must have `resourcemanager.projects.delete` permissions for
  /// this project.
  ///
  /// @param name  Required. The name of the Project (for example,
  /// `projects/415104041262`).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.DeleteProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L605}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> DeleteProject(
      std::string const& name, Options options = {});

  ///
  /// Marks the project identified by the specified
  /// `name` (for example, `projects/415104041262`) for deletion.
  ///
  /// This method will only affect the project if it has a lifecycle state of
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE].
  ///
  /// This method changes the Project's lifecycle state from
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE]
  /// to
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED].
  /// The deletion starts at an unspecified time,
  /// at which point the Project is no longer accessible.
  ///
  /// Until the deletion completes, you can check the lifecycle state
  /// checked by retrieving the project with [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// and the project remains visible to [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects].
  /// However, you cannot update the project.
  ///
  /// After the deletion completes, the project is not retrievable by
  /// the  [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects], and
  /// [SearchProjects][google.cloud.resourcemanager.v3.Projects.SearchProjects]
  /// methods.
  ///
  /// This method behaves idempotently, such that deleting a `DELETE_REQUESTED`
  /// project will not cause an error, but also won't do anything.
  ///
  /// The caller must have `resourcemanager.projects.delete` permissions for
  /// this project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::DeleteProjectRequest,google/cloud/resourcemanager/v3/projects.proto#L605}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.DeleteProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L605}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> DeleteProject(
      google::cloud::resourcemanager::v3::DeleteProjectRequest const& request,
      Options options = {});

  ///
  /// Restores the project identified by the specified
  /// `name` (for example, `projects/415104041262`).
  /// You can only use this method for a project that has a lifecycle state of
  /// [DELETE_REQUESTED]
  /// [Projects.State.DELETE_REQUESTED].
  /// After deletion starts, the project cannot be restored.
  ///
  /// The caller must have `resourcemanager.projects.undelete` permission for
  /// this project.
  ///
  /// @param name  Required. The name of the project (for example,
  /// `projects/415104041262`).
  ///  Required.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.UndeleteProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L624}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UndeleteProject(
      std::string const& name, Options options = {});

  ///
  /// Restores the project identified by the specified
  /// `name` (for example, `projects/415104041262`).
  /// You can only use this method for a project that has a lifecycle state of
  /// [DELETE_REQUESTED]
  /// [Projects.State.DELETE_REQUESTED].
  /// After deletion starts, the project cannot be restored.
  ///
  /// The caller must have `resourcemanager.projects.undelete` permission for
  /// this project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::resourcemanager::v3::UndeleteProjectRequest,google/cloud/resourcemanager/v3/projects.proto#L624}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::resourcemanager::v3::Project,google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  /// [google.cloud.resourcemanager.v3.UndeleteProjectRequest]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L624}
  /// [google.cloud.resourcemanager.v3.Project]:
  /// @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L285}
  ///
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UndeleteProject(
      google::cloud::resourcemanager::v3::UndeleteProjectRequest const& request,
      Options options = {});

  ///
  /// Returns the IAM access control policy for the specified project.
  /// Permission is denied if the policy or the resource do not exist.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(std::string const& resource,
                                                 Options options = {});

  ///
  /// Returns the IAM access control policy for the specified project.
  /// Permission is denied if the policy or the resource do not exist.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::GetIamPolicyRequest,google/iam/v1/iam_policy.proto#L113}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.GetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L113}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Sets the IAM access control policy for the specified project.
  ///
  /// CAUTION: This method will replace the existing policy, and cannot be used
  /// to append additional IAM settings.
  ///
  /// Note: Removing service accounts from policies or changing their roles can
  /// render services completely inoperable. It is important to understand how
  /// the service account is being used before removing or updating its roles.
  ///
  /// The following constraints apply when using `setIamPolicy()`:
  ///
  /// + Project does not support `allUsers` and `allAuthenticatedUsers` as
  /// `members` in a `Binding` of a `Policy`.
  ///
  /// + The owner role can be granted to a `user`, `serviceAccount`, or a group
  /// that is part of an organization. For example,
  /// group@myownpersonaldomain.com could be added as an owner to a project in
  /// the myownpersonaldomain.com organization, but not the examplepetstore.com
  /// organization.
  ///
  /// + Service accounts can be made owners of a project directly
  /// without any restrictions. However, to be added as an owner, a user must be
  /// invited using the Cloud Platform console and must accept the invitation.
  ///
  /// + A user cannot be granted the owner role using `setIamPolicy()`. The user
  /// must be granted the owner role using the Cloud Platform Console and must
  /// explicitly accept the invitation.
  ///
  /// + Invitations to grant the owner role cannot be sent using
  /// `setIamPolicy()`;
  /// they must be sent only using the Cloud Platform Console.
  ///
  /// + Membership changes that leave the project without any owners that have
  /// accepted the Terms of Service (ToS) will be rejected.
  ///
  /// + If the project is not part of an organization, there must be at least
  /// one owner who has accepted the Terms of Service (ToS) agreement in the
  /// policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner
  /// from the policy will fail. This restriction also applies to legacy
  /// projects that no longer have owners who have accepted the ToS. Edits to
  /// IAM policies will be rejected until the lack of a ToS-accepting owner is
  /// rectified.
  ///
  /// + Calling this method requires enabling the App Engine Admin API.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being
  /// specified.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param policy  REQUIRED: The complete policy to be applied to the
  /// `resource`. The size of
  ///  the policy is limited to a few 10s of KB. An empty policy is a
  ///  valid policy but certain Cloud Platform services (such as Projects)
  ///  might reject them.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      std::string const& resource, google::iam::v1::Policy const& policy,
      Options options = {});

  ///
  /// Sets the IAM access control policy for the specified project.
  ///
  /// CAUTION: This method will replace the existing policy, and cannot be used
  /// to append additional IAM settings.
  ///
  /// Note: Removing service accounts from policies or changing their roles can
  /// render services completely inoperable. It is important to understand how
  /// the service account is being used before removing or updating its roles.
  ///
  /// The following constraints apply when using `setIamPolicy()`:
  ///
  /// + Project does not support `allUsers` and `allAuthenticatedUsers` as
  /// `members` in a `Binding` of a `Policy`.
  ///
  /// + The owner role can be granted to a `user`, `serviceAccount`, or a group
  /// that is part of an organization. For example,
  /// group@myownpersonaldomain.com could be added as an owner to a project in
  /// the myownpersonaldomain.com organization, but not the examplepetstore.com
  /// organization.
  ///
  /// + Service accounts can be made owners of a project directly
  /// without any restrictions. However, to be added as an owner, a user must be
  /// invited using the Cloud Platform console and must accept the invitation.
  ///
  /// + A user cannot be granted the owner role using `setIamPolicy()`. The user
  /// must be granted the owner role using the Cloud Platform Console and must
  /// explicitly accept the invitation.
  ///
  /// + Invitations to grant the owner role cannot be sent using
  /// `setIamPolicy()`;
  /// they must be sent only using the Cloud Platform Console.
  ///
  /// + Membership changes that leave the project without any owners that have
  /// accepted the Terms of Service (ToS) will be rejected.
  ///
  /// + If the project is not part of an organization, there must be at least
  /// one owner who has accepted the Terms of Service (ToS) agreement in the
  /// policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner
  /// from the policy will fail. This restriction also applies to legacy
  /// projects that no longer have owners who have accepted the ToS. Edits to
  /// IAM policies will be rejected until the lack of a ToS-accepting owner is
  /// rectified.
  ///
  /// + Calling this method requires enabling the App Engine Admin API.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::SetIamPolicyRequest,google/iam/v1/iam_policy.proto#L98}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::Policy,google/iam/v1/policy.proto#L88}
  ///
  /// [google.iam.v1.SetIamPolicyRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L98}
  /// [google.iam.v1.Policy]:
  /// @googleapis_reference_link{google/iam/v1/policy.proto#L88}
  ///
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Returns permissions that a caller has on the specified project.
  ///
  /// @param resource  REQUIRED: The resource for which the policy detail is
  /// being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param permissions  The set of permissions to check for the `resource`.
  /// Permissions with
  ///  wildcards (such as '*' or 'storage.*') are not allowed. For more
  ///  information see
  ///  [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      std::string const& resource, std::vector<std::string> const& permissions,
      Options options = {});

  ///
  /// Returns permissions that a caller has on the specified project.
  ///
  /// @param request
  /// @googleapis_link{google::iam::v1::TestIamPermissionsRequest,google/iam/v1/iam_policy.proto#L126}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::iam::v1::TestIamPermissionsResponse,google/iam/v1/iam_policy.proto#L141}
  ///
  /// [google.iam.v1.TestIamPermissionsRequest]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L126}
  /// [google.iam.v1.TestIamPermissionsResponse]:
  /// @googleapis_reference_link{google/iam/v1/iam_policy.proto#L141}
  ///
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<ProjectsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_PROJECTS_CLIENT_H
