// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/organizations.proto

#include "google/cloud/resourcemanager/organizations_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

OrganizationsConnectionIdempotencyPolicy::
    ~OrganizationsConnectionIdempotencyPolicy() = default;

namespace {
class DefaultOrganizationsConnectionIdempotencyPolicy
    : public OrganizationsConnectionIdempotencyPolicy {
 public:
  ~DefaultOrganizationsConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<OrganizationsConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultOrganizationsConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency GetOrganization(
      google::cloud::resourcemanager::v3::GetOrganizationRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency SearchOrganizations(
      google::cloud::resourcemanager::v3::SearchOrganizationsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<OrganizationsConnectionIdempotencyPolicy>
MakeDefaultOrganizationsConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultOrganizationsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager
}  // namespace cloud
}  // namespace google
