// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/organizations.proto

#include "google/cloud/resourcemanager/organizations_connection.h"
#include "google/cloud/resourcemanager/internal/organizations_connection_impl.h"
#include "google/cloud/resourcemanager/internal/organizations_option_defaults.h"
#include "google/cloud/resourcemanager/internal/organizations_stub_factory.h"
#include "google/cloud/resourcemanager/organizations_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

OrganizationsConnection::~OrganizationsConnection() = default;

StatusOr<google::cloud::resourcemanager::v3::Organization>
OrganizationsConnection::GetOrganization(
    google::cloud::resourcemanager::v3::GetOrganizationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::resourcemanager::v3::Organization>
OrganizationsConnection::SearchOrganizations(
    google::cloud::resourcemanager::v3::SearchOrganizationsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Organization>>(
      std::move(request),
      [](google::cloud::resourcemanager::v3::
             SearchOrganizationsRequest const&) {
        return StatusOr<
            google::cloud::resourcemanager::v3::SearchOrganizationsResponse>{};
      },
      [](google::cloud::resourcemanager::v3::
             SearchOrganizationsResponse const&) {
        return std::vector<google::cloud::resourcemanager::v3::Organization>();
      });
}

StatusOr<google::iam::v1::Policy> OrganizationsConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> OrganizationsConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
OrganizationsConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<OrganizationsConnection> MakeOrganizationsConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 OrganizationsPolicyOptionList>(options,
                                                                __func__);
  options =
      resourcemanager_internal::OrganizationsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = resourcemanager_internal::CreateDefaultOrganizationsStub(
      background->cq(), options);
  return std::make_shared<
      resourcemanager_internal::OrganizationsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace resourcemanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<resourcemanager::OrganizationsConnection>
MakeOrganizationsConnection(std::shared_ptr<OrganizationsStub> stub,
                            Options options) {
  options = OrganizationsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      resourcemanager_internal::OrganizationsConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_internal
}  // namespace cloud
}  // namespace google
