// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/projects.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_MOCKS_MOCK_PROJECTS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_MOCKS_MOCK_PROJECTS_CONNECTION_H

#include "google/cloud/resourcemanager/projects_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace resourcemanager_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MockProjectsConnection : public resourcemanager::ProjectsConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::resourcemanager::v3::Project>, GetProject,
      (google::cloud::resourcemanager::v3::GetProjectRequest const& request),
      (override));

  MOCK_METHOD(StreamRange<google::cloud::resourcemanager::v3::Project>,
              ListProjects,
              (google::cloud::resourcemanager::v3::ListProjectsRequest request),
              (override));

  MOCK_METHOD(
      StreamRange<google::cloud::resourcemanager::v3::Project>, SearchProjects,
      (google::cloud::resourcemanager::v3::SearchProjectsRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::resourcemanager::v3::Project>>,
      CreateProject,
      (google::cloud::resourcemanager::v3::CreateProjectRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::resourcemanager::v3::Project>>,
      UpdateProject,
      (google::cloud::resourcemanager::v3::UpdateProjectRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::resourcemanager::v3::Project>>,
      MoveProject,
      (google::cloud::resourcemanager::v3::MoveProjectRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::resourcemanager::v3::Project>>,
      DeleteProject,
      (google::cloud::resourcemanager::v3::DeleteProjectRequest const& request),
      (override));

  MOCK_METHOD(future<StatusOr<google::cloud::resourcemanager::v3::Project>>,
              UndeleteProject,
              (google::cloud::resourcemanager::v3::UndeleteProjectRequest const&
                   request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, GetIamPolicy,
              (google::iam::v1::GetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, SetIamPolicy,
              (google::iam::v1::SetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::TestIamPermissionsResponse>,
              TestIamPermissions,
              (google::iam::v1::TestIamPermissionsRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_MOCKS_MOCK_PROJECTS_CONNECTION_H
