// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/organizations.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_INTERNAL_ORGANIZATIONS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_INTERNAL_ORGANIZATIONS_CONNECTION_IMPL_H

#include "google/cloud/resourcemanager/internal/organizations_retry_traits.h"
#include "google/cloud/resourcemanager/internal/organizations_stub.h"
#include "google/cloud/resourcemanager/organizations_connection.h"
#include "google/cloud/resourcemanager/organizations_connection_idempotency_policy.h"
#include "google/cloud/resourcemanager/organizations_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class OrganizationsConnectionImpl
    : public resourcemanager::OrganizationsConnection {
 public:
  ~OrganizationsConnectionImpl() override = default;

  OrganizationsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<resourcemanager_internal::OrganizationsStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::resourcemanager::v3::Organization> GetOrganization(
      google::cloud::resourcemanager::v3::GetOrganizationRequest const& request)
      override;

  StreamRange<google::cloud::resourcemanager::v3::Organization>
  SearchOrganizations(
      google::cloud::resourcemanager::v3::SearchOrganizationsRequest request)
      override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

 private:
  std::unique_ptr<resourcemanager::OrganizationsRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<resourcemanager::OrganizationsRetryPolicyOption>()) {
      return options.get<resourcemanager::OrganizationsRetryPolicyOption>()
          ->clone();
    }
    return options_.get<resourcemanager::OrganizationsRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<resourcemanager::OrganizationsBackoffPolicyOption>()) {
      return options.get<resourcemanager::OrganizationsBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<resourcemanager::OrganizationsBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<resourcemanager::OrganizationsConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<resourcemanager::
                        OrganizationsConnectionIdempotencyPolicyOption>()) {
      return options
          .get<
              resourcemanager::OrganizationsConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<resourcemanager::OrganizationsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<resourcemanager_internal::OrganizationsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_INTERNAL_ORGANIZATIONS_CONNECTION_IMPL_H
