// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/folders.proto

#include "google/cloud/resourcemanager/internal/folders_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/resourcemanager/v3/folders.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FoldersMetadata::FoldersMetadata(std::shared_ptr<FoldersStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::resourcemanager::v3::Folder> FoldersMetadata::GetFolder(
    grpc::ClientContext& context,
    google::cloud::resourcemanager::v3::GetFolderRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetFolder(context, request);
}

StatusOr<google::cloud::resourcemanager::v3::ListFoldersResponse>
FoldersMetadata::ListFolders(
    grpc::ClientContext& context,
    google::cloud::resourcemanager::v3::ListFoldersRequest const& request) {
  SetMetadata(context, {});
  return child_->ListFolders(context, request);
}

StatusOr<google::cloud::resourcemanager::v3::SearchFoldersResponse>
FoldersMetadata::SearchFolders(
    grpc::ClientContext& context,
    google::cloud::resourcemanager::v3::SearchFoldersRequest const& request) {
  SetMetadata(context, {});
  return child_->SearchFolders(context, request);
}

future<StatusOr<google::longrunning::Operation>>
FoldersMetadata::AsyncCreateFolder(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::resourcemanager::v3::CreateFolderRequest const& request) {
  SetMetadata(*context, {});
  return child_->AsyncCreateFolder(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
FoldersMetadata::AsyncUpdateFolder(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::resourcemanager::v3::UpdateFolderRequest const& request) {
  SetMetadata(*context, "folder.name=" + request.folder().name());
  return child_->AsyncUpdateFolder(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
FoldersMetadata::AsyncMoveFolder(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::resourcemanager::v3::MoveFolderRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncMoveFolder(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
FoldersMetadata::AsyncDeleteFolder(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::resourcemanager::v3::DeleteFolderRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteFolder(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
FoldersMetadata::AsyncUndeleteFolder(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::resourcemanager::v3::UndeleteFolderRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncUndeleteFolder(cq, std::move(context), request);
}

StatusOr<google::iam::v1::Policy> FoldersMetadata::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(context, "resource=" + request.resource());
  return child_->GetIamPolicy(context, request);
}

StatusOr<google::iam::v1::Policy> FoldersMetadata::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(context, "resource=" + request.resource());
  return child_->SetIamPolicy(context, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FoldersMetadata::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(context, "resource=" + request.resource());
  return child_->TestIamPermissions(context, request);
}

future<StatusOr<google::longrunning::Operation>>
FoldersMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> FoldersMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void FoldersMetadata::SetMetadata(grpc::ClientContext& context,
                                  std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void FoldersMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_internal
}  // namespace cloud
}  // namespace google
