// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/folders.proto

#include "google/cloud/resourcemanager/internal/folders_connection_impl.h"
#include "google/cloud/resourcemanager/internal/folders_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FoldersConnectionImpl::FoldersConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<resourcemanager_internal::FoldersStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), resourcemanager_internal::FoldersDefaultOptions(
                                  FoldersConnection::options()))) {}

StatusOr<google::cloud::resourcemanager::v3::Folder>
FoldersConnectionImpl::GetFolder(
    google::cloud::resourcemanager::v3::GetFolderRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetFolder(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::resourcemanager::v3::GetFolderRequest const& request) {
        return stub_->GetFolder(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersConnectionImpl::ListFolders(
    google::cloud::resourcemanager::v3::ListFoldersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<resourcemanager::FoldersRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListFolders(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Folder>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::resourcemanager::v3::ListFoldersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::resourcemanager::v3::ListFoldersRequest const&
                       request) { return stub->ListFolders(context, request); },
            r, function_name);
      },
      [](google::cloud::resourcemanager::v3::ListFoldersResponse r) {
        std::vector<google::cloud::resourcemanager::v3::Folder> result(
            r.folders().size());
        auto& messages = *r.mutable_folders();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersConnectionImpl::SearchFolders(
    google::cloud::resourcemanager::v3::SearchFoldersRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<resourcemanager::FoldersRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->SearchFolders(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Folder>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::cloud::resourcemanager::v3::SearchFoldersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::resourcemanager::v3::SearchFoldersRequest const&
                    request) { return stub->SearchFolders(context, request); },
            r, function_name);
      },
      [](google::cloud::resourcemanager::v3::SearchFoldersResponse r) {
        std::vector<google::cloud::resourcemanager::v3::Folder> result(
            r.folders().size());
        auto& messages = *r.mutable_folders();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnectionImpl::CreateFolder(
    google::cloud::resourcemanager::v3::CreateFolderRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::resourcemanager::v3::Folder>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::resourcemanager::v3::CreateFolderRequest const&
                 request) {
        return stub->AsyncCreateFolder(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::resourcemanager::v3::Folder>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateFolder(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnectionImpl::UpdateFolder(
    google::cloud::resourcemanager::v3::UpdateFolderRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::resourcemanager::v3::Folder>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::resourcemanager::v3::UpdateFolderRequest const&
                 request) {
        return stub->AsyncUpdateFolder(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::resourcemanager::v3::Folder>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateFolder(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnectionImpl::MoveFolder(
    google::cloud::resourcemanager::v3::MoveFolderRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::resourcemanager::v3::Folder>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::resourcemanager::v3::MoveFolderRequest const&
                 request) {
        return stub->AsyncMoveFolder(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::resourcemanager::v3::Folder>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->MoveFolder(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnectionImpl::DeleteFolder(
    google::cloud::resourcemanager::v3::DeleteFolderRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::resourcemanager::v3::Folder>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::resourcemanager::v3::DeleteFolderRequest const&
                 request) {
        return stub->AsyncDeleteFolder(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::resourcemanager::v3::Folder>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteFolder(request), polling_policy(), __func__);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersConnectionImpl::UndeleteFolder(
    google::cloud::resourcemanager::v3::UndeleteFolderRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::resourcemanager::v3::Folder>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::cloud::resourcemanager::v3::UndeleteFolderRequest const&
                 request) {
        return stub->AsyncUndeleteFolder(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::resourcemanager::v3::Folder>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UndeleteFolder(request), polling_policy(),
      __func__);
}

StatusOr<google::iam::v1::Policy> FoldersConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> FoldersConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FoldersConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_internal
}  // namespace cloud
}  // namespace google
