// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/folders.proto

#include "google/cloud/resourcemanager/folders_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

FoldersConnectionIdempotencyPolicy::~FoldersConnectionIdempotencyPolicy() =
    default;

namespace {
class DefaultFoldersConnectionIdempotencyPolicy
    : public FoldersConnectionIdempotencyPolicy {
 public:
  ~DefaultFoldersConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<FoldersConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultFoldersConnectionIdempotencyPolicy>(*this);
  }

  Idempotency GetFolder(
      google::cloud::resourcemanager::v3::GetFolderRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListFolders(
      google::cloud::resourcemanager::v3::ListFoldersRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency SearchFolders(
      google::cloud::resourcemanager::v3::SearchFoldersRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateFolder(
      google::cloud::resourcemanager::v3::CreateFolderRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateFolder(
      google::cloud::resourcemanager::v3::UpdateFolderRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency MoveFolder(
      google::cloud::resourcemanager::v3::MoveFolderRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteFolder(
      google::cloud::resourcemanager::v3::DeleteFolderRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UndeleteFolder(
      google::cloud::resourcemanager::v3::UndeleteFolderRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<FoldersConnectionIdempotencyPolicy>
MakeDefaultFoldersConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultFoldersConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager
}  // namespace cloud
}  // namespace google
