// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/redis/v1/cloud_redis.proto

#include "google/cloud/redis/cloud_redis_connection.h"
#include "google/cloud/redis/cloud_redis_options.h"
#include "google/cloud/redis/internal/cloud_redis_connection_impl.h"
#include "google/cloud/redis/internal/cloud_redis_option_defaults.h"
#include "google/cloud/redis/internal/cloud_redis_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace redis {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudRedisConnection::~CloudRedisConnection() = default;

StreamRange<google::cloud::redis::v1::Instance>
CloudRedisConnection::ListInstances(
    google::cloud::redis::v1::ListInstancesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::redis::v1::Instance>>(
      std::move(request),
      [](google::cloud::redis::v1::ListInstancesRequest const&) {
        return StatusOr<google::cloud::redis::v1::ListInstancesResponse>{};
      },
      [](google::cloud::redis::v1::ListInstancesResponse const&) {
        return std::vector<google::cloud::redis::v1::Instance>();
      });
}

StatusOr<google::cloud::redis::v1::Instance> CloudRedisConnection::GetInstance(
    google::cloud::redis::v1::GetInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisConnection::CreateInstance(
    google::cloud::redis::v1::CreateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::redis::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisConnection::UpdateInstance(
    google::cloud::redis::v1::UpdateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::redis::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisConnection::UpgradeInstance(
    google::cloud::redis::v1::UpgradeInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::redis::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisConnection::ImportInstance(
    google::cloud::redis::v1::ImportInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::redis::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisConnection::ExportInstance(
    google::cloud::redis::v1::ExportInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::redis::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisConnection::FailoverInstance(
    google::cloud::redis::v1::FailoverInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::redis::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::redis::v1::OperationMetadata>>
CloudRedisConnection::DeleteInstance(
    google::cloud::redis::v1::DeleteInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::redis::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<CloudRedisConnection> MakeCloudRedisConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 CloudRedisPolicyOptionList>(options, __func__);
  options = redis_internal::CloudRedisDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      redis_internal::CreateDefaultCloudRedisStub(background->cq(), options);
  return std::make_shared<redis_internal::CloudRedisConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace redis
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace redis_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<redis::CloudRedisConnection> MakeCloudRedisConnection(
    std::shared_ptr<CloudRedisStub> stub, Options options) {
  options = CloudRedisDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<redis_internal::CloudRedisConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace redis_internal
}  // namespace cloud
}  // namespace google
