// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/redis/v1/cloud_redis.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_REDIS_CLOUD_REDIS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_REDIS_CLOUD_REDIS_CLIENT_H

#include "google/cloud/redis/cloud_redis_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace redis {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Configures and manages Cloud Memorystore for Redis instances
///
/// Google Cloud Memorystore for Redis v1
///
/// The `redis.googleapis.com` service implements the Google Cloud Memorystore
/// for Redis API and defines the following resource model for managing Redis
/// instances:
/// * The service works with a collection of cloud projects, named:
/// `/projects/*`
/// * Each project has a collection of available locations, named:
/// `/locations/*`
/// * Each location has a collection of Redis instances, named: `/instances/*`
/// * As such, Redis instances are resources of the form:
///   `/projects/{project_id}/locations/{location_id}/instances/{instance_id}`
///
/// Note that location_id must be referring to a GCP `region`; for example:
/// * `projects/redpepper-1290/locations/us-central1/instances/my-redis`
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CloudRedisClient {
 public:
  explicit CloudRedisClient(std::shared_ptr<CloudRedisConnection> connection,
                            Options options = {});
  ~CloudRedisClient();

  //@{
  // @name Copy and move support
  CloudRedisClient(CloudRedisClient const&) = default;
  CloudRedisClient& operator=(CloudRedisClient const&) = default;
  CloudRedisClient(CloudRedisClient&&) = default;
  CloudRedisClient& operator=(CloudRedisClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(CloudRedisClient const& a, CloudRedisClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CloudRedisClient const& a, CloudRedisClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists all Redis instances owned by a project in either the specified
  /// location (region) or all locations.
  ///
  /// The location should have the following format:
  ///
  /// * `projects/{project_id}/locations/{location_id}`
  ///
  /// If `location_id` is specified as `-` (wildcard), then all regions
  /// available to the project are queried, and the results are aggregated.
  ///
  /// @param parent  Required. The resource name of the instance location using
  /// the form:
  ///      `projects/{project_id}/locations/{location_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.ListInstancesRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L426}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  StreamRange<google::cloud::redis::v1::Instance> ListInstances(
      std::string const& parent, Options options = {});

  ///
  /// Lists all Redis instances owned by a project in either the specified
  /// location (region) or all locations.
  ///
  /// The location should have the following format:
  ///
  /// * `projects/{project_id}/locations/{location_id}`
  ///
  /// If `location_id` is specified as `-` (wildcard), then all regions
  /// available to the project are queried, and the results are aggregated.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::ListInstancesRequest,google/cloud/redis/v1/cloud_redis.proto#L426}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.ListInstancesRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L426}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  StreamRange<google::cloud::redis::v1::Instance> ListInstances(
      google::cloud::redis::v1::ListInstancesRequest request,
      Options options = {});

  ///
  /// Gets the details of a specific Redis instance.
  ///
  /// @param name  Required. Redis instance resource name using the form:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.GetInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L475}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  StatusOr<google::cloud::redis::v1::Instance> GetInstance(
      std::string const& name, Options options = {});

  ///
  /// Gets the details of a specific Redis instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::GetInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L475}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.GetInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L475}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  StatusOr<google::cloud::redis::v1::Instance> GetInstance(
      google::cloud::redis::v1::GetInstanceRequest const& request,
      Options options = {});

  ///
  /// Creates a Redis instance based on the specified tier and memory size.
  ///
  /// By default, the instance is accessible from the project's
  /// [default network](https://cloud.google.com/vpc/docs/vpc).
  ///
  /// The creation is executed asynchronously and callers may check the returned
  /// operation to track its progress. Once the operation is completed the Redis
  /// instance will be fully functional. Completed longrunning.Operation will
  /// contain the new instance object in the response field.
  ///
  /// The returned operation is automatically deleted after a few hours, so
  /// there is no need to call DeleteOperation.
  ///
  /// @param parent  Required. The resource name of the instance location using
  /// the form:
  ///      `projects/{project_id}/locations/{location_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param instance_id  Required. The logical name of the Redis instance in
  /// the customer project
  ///  with the following restrictions:
  ///  * Must contain only lowercase letters, numbers, and hyphens.
  ///  * Must start with a letter.
  ///  * Must be between 1-40 characters.
  ///  * Must end with a number or a letter.
  ///  * Must be unique within the customer project / location
  /// @param instance  Required. A Redis [Instance] resource
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.CreateInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L488}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> CreateInstance(
      std::string const& parent, std::string const& instance_id,
      google::cloud::redis::v1::Instance const& instance, Options options = {});

  ///
  /// Creates a Redis instance based on the specified tier and memory size.
  ///
  /// By default, the instance is accessible from the project's
  /// [default network](https://cloud.google.com/vpc/docs/vpc).
  ///
  /// The creation is executed asynchronously and callers may check the returned
  /// operation to track its progress. Once the operation is completed the Redis
  /// instance will be fully functional. Completed longrunning.Operation will
  /// contain the new instance object in the response field.
  ///
  /// The returned operation is automatically deleted after a few hours, so
  /// there is no need to call DeleteOperation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::CreateInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L488}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.CreateInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L488}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> CreateInstance(
      google::cloud::redis::v1::CreateInstanceRequest const& request,
      Options options = {});

  ///
  /// Updates the metadata and configuration of a specific Redis instance.
  ///
  /// Completed longrunning.Operation will contain the new instance object
  /// in the response field. The returned operation is automatically deleted
  /// after a few hours, so there is no need to call DeleteOperation.
  ///
  /// @param update_mask  Required. Mask of fields to update. At least one path
  /// must be supplied in
  ///  this field. The elements of the repeated paths field may only include
  ///  these fields from [Instance][google.cloud.redis.v1.Instance]:
  ///   *   `displayName`
  ///   *   `labels`
  ///   *   `memorySizeGb`
  ///   *   `redisConfig`
  ///   *   `replica_count`
  /// @param instance  Required. Update description.
  ///  Only fields specified in update_mask are updated.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.UpdateInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L514}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> UpdateInstance(
      google::protobuf::FieldMask const& update_mask,
      google::cloud::redis::v1::Instance const& instance, Options options = {});

  ///
  /// Updates the metadata and configuration of a specific Redis instance.
  ///
  /// Completed longrunning.Operation will contain the new instance object
  /// in the response field. The returned operation is automatically deleted
  /// after a few hours, so there is no need to call DeleteOperation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::UpdateInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L514}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.UpdateInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L514}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> UpdateInstance(
      google::cloud::redis::v1::UpdateInstanceRequest const& request,
      Options options = {});

  ///
  /// Upgrades Redis instance to the newer Redis version specified in the
  /// request.
  ///
  /// @param name  Required. Redis instance resource name using the form:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param redis_version  Required. Specifies the target version of Redis
  /// software to upgrade to.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.UpgradeInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L532}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> UpgradeInstance(
      std::string const& name, std::string const& redis_version,
      Options options = {});

  ///
  /// Upgrades Redis instance to the newer Redis version specified in the
  /// request.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::UpgradeInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L532}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.UpgradeInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L532}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> UpgradeInstance(
      google::cloud::redis::v1::UpgradeInstanceRequest const& request,
      Options options = {});

  ///
  /// Import a Redis RDB snapshot file from Cloud Storage into a Redis instance.
  ///
  /// Redis may stop serving during this operation. Instance state will be
  /// IMPORTING for entire operation. When complete, the instance will contain
  /// only data from the imported file.
  ///
  /// The returned operation is automatically deleted after a few hours, so
  /// there is no need to call DeleteOperation.
  ///
  /// @param name  Required. Redis instance resource name using the form:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param input_config  Required. Specify data to be imported.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.ImportInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L576}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> ImportInstance(
      std::string const& name,
      google::cloud::redis::v1::InputConfig const& input_config,
      Options options = {});

  ///
  /// Import a Redis RDB snapshot file from Cloud Storage into a Redis instance.
  ///
  /// Redis may stop serving during this operation. Instance state will be
  /// IMPORTING for entire operation. When complete, the instance will contain
  /// only data from the imported file.
  ///
  /// The returned operation is automatically deleted after a few hours, so
  /// there is no need to call DeleteOperation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::ImportInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L576}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.ImportInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L576}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> ImportInstance(
      google::cloud::redis::v1::ImportInstanceRequest const& request,
      Options options = {});

  ///
  /// Export Redis instance data into a Redis RDB format file in Cloud Storage.
  ///
  /// Redis will continue serving during this operation.
  ///
  /// The returned operation is automatically deleted after a few hours, so
  /// there is no need to call DeleteOperation.
  ///
  /// @param name  Required. Redis instance resource name using the form:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param output_config  Required. Specify data to be exported.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.ExportInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L603}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> ExportInstance(
      std::string const& name,
      google::cloud::redis::v1::OutputConfig const& output_config,
      Options options = {});

  ///
  /// Export Redis instance data into a Redis RDB format file in Cloud Storage.
  ///
  /// Redis will continue serving during this operation.
  ///
  /// The returned operation is automatically deleted after a few hours, so
  /// there is no need to call DeleteOperation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::ExportInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L603}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.ExportInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L603}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> ExportInstance(
      google::cloud::redis::v1::ExportInstanceRequest const& request,
      Options options = {});

  ///
  /// Initiates a failover of the primary node to current replica node for a
  /// specific STANDARD tier Cloud Memorystore for Redis instance.
  ///
  /// @param name  Required. Redis instance resource name using the form:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param data_protection_mode  Optional. Available data protection modes
  /// that the user can choose. If it's
  ///  unspecified, data protection mode will be LIMITED_DATA_LOSS by default.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.FailoverInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L614}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> FailoverInstance(
      std::string const& name,
      google::cloud::redis::v1::FailoverInstanceRequest::DataProtectionMode
          data_protection_mode,
      Options options = {});

  ///
  /// Initiates a failover of the primary node to current replica node for a
  /// specific STANDARD tier Cloud Memorystore for Redis instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::FailoverInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L614}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::Instance,google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  /// [google.cloud.redis.v1.FailoverInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L614}
  /// [google.cloud.redis.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L206}
  ///
  future<StatusOr<google::cloud::redis::v1::Instance>> FailoverInstance(
      google::cloud::redis::v1::FailoverInstanceRequest const& request,
      Options options = {});

  ///
  /// Deletes a specific Redis instance.  Instance stops serving and data is
  /// deleted.
  ///
  /// @param name  Required. Redis instance resource name using the form:
  ///      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
  ///  where `location_id` refers to a GCP region.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::OperationMetadata,google/cloud/redis/v1/cloud_redis.proto#L647}
  ///
  /// [google.cloud.redis.v1.DeleteInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L548}
  /// [google.cloud.redis.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L647}
  ///
  future<StatusOr<google::cloud::redis::v1::OperationMetadata>> DeleteInstance(
      std::string const& name, Options options = {});

  ///
  /// Deletes a specific Redis instance.  Instance stops serving and data is
  /// deleted.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::redis::v1::DeleteInstanceRequest,google/cloud/redis/v1/cloud_redis.proto#L548}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::redis::v1::OperationMetadata,google/cloud/redis/v1/cloud_redis.proto#L647}
  ///
  /// [google.cloud.redis.v1.DeleteInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L548}
  /// [google.cloud.redis.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/redis/v1/cloud_redis.proto#L647}
  ///
  future<StatusOr<google::cloud::redis::v1::OperationMetadata>> DeleteInstance(
      google::cloud::redis::v1::DeleteInstanceRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<CloudRedisConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace redis
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_REDIS_CLOUD_REDIS_CLIENT_H
