// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recommender/v1/recommender_service.proto

#include "google/cloud/recommender/recommender_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace recommender {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

RecommenderConnectionIdempotencyPolicy::
    ~RecommenderConnectionIdempotencyPolicy() = default;

namespace {
class DefaultRecommenderConnectionIdempotencyPolicy
    : public RecommenderConnectionIdempotencyPolicy {
 public:
  ~DefaultRecommenderConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<RecommenderConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultRecommenderConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListInsights(
      google::cloud::recommender::v1::ListInsightsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetInsight(
      google::cloud::recommender::v1::GetInsightRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency MarkInsightAccepted(
      google::cloud::recommender::v1::MarkInsightAcceptedRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListRecommendations(
      google::cloud::recommender::v1::ListRecommendationsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetRecommendation(
      google::cloud::recommender::v1::GetRecommendationRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency MarkRecommendationClaimed(
      google::cloud::recommender::v1::MarkRecommendationClaimedRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency MarkRecommendationSucceeded(
      google::cloud::recommender::v1::MarkRecommendationSucceededRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency MarkRecommendationFailed(
      google::cloud::recommender::v1::MarkRecommendationFailedRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<RecommenderConnectionIdempotencyPolicy>
MakeDefaultRecommenderConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultRecommenderConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recommender
}  // namespace cloud
}  // namespace google
