// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/pubsublite/v1/topic_stats.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_TOPIC_STATS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_TOPIC_STATS_CLIENT_H

#include "google/cloud/pubsublite/topic_stats_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsublite {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// This service allows users to get stats about messages in their topic.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class TopicStatsServiceClient {
 public:
  explicit TopicStatsServiceClient(
      std::shared_ptr<TopicStatsServiceConnection> connection,
      Options options = {});
  ~TopicStatsServiceClient();

  //@{
  // @name Copy and move support
  TopicStatsServiceClient(TopicStatsServiceClient const&) = default;
  TopicStatsServiceClient& operator=(TopicStatsServiceClient const&) = default;
  TopicStatsServiceClient(TopicStatsServiceClient&&) = default;
  TopicStatsServiceClient& operator=(TopicStatsServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(TopicStatsServiceClient const& a,
                         TopicStatsServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TopicStatsServiceClient const& a,
                         TopicStatsServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Compute statistics about a range of messages in a given topic and
  /// partition.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ComputeMessageStatsRequest,google/cloud/pubsublite/v1/topic_stats.proto#L72}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::ComputeMessageStatsResponse,google/cloud/pubsublite/v1/topic_stats.proto#L94}
  ///
  /// [google.cloud.pubsublite.v1.ComputeMessageStatsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/topic_stats.proto#L72}
  /// [google.cloud.pubsublite.v1.ComputeMessageStatsResponse]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/topic_stats.proto#L94}
  ///
  StatusOr<google::cloud::pubsublite::v1::ComputeMessageStatsResponse>
  ComputeMessageStats(
      google::cloud::pubsublite::v1::ComputeMessageStatsRequest const& request,
      Options options = {});

  ///
  /// Compute the head cursor for the partition.
  /// The head cursor's offset is guaranteed to be less than or equal to all
  /// messages which have not yet been acknowledged as published, and
  /// greater than the offset of any message whose publish has already
  /// been acknowledged. It is zero if there have never been messages in the
  /// partition.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ComputeHeadCursorRequest,google/cloud/pubsublite/v1/topic_stats.proto#L113}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::ComputeHeadCursorResponse,google/cloud/pubsublite/v1/topic_stats.proto#L127}
  ///
  /// [google.cloud.pubsublite.v1.ComputeHeadCursorRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/topic_stats.proto#L113}
  /// [google.cloud.pubsublite.v1.ComputeHeadCursorResponse]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/topic_stats.proto#L127}
  ///
  StatusOr<google::cloud::pubsublite::v1::ComputeHeadCursorResponse>
  ComputeHeadCursor(
      google::cloud::pubsublite::v1::ComputeHeadCursorRequest const& request,
      Options options = {});

  ///
  /// Compute the corresponding cursor for a publish or event time in a topic
  /// partition.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ComputeTimeCursorRequest,google/cloud/pubsublite/v1/topic_stats.proto#L134}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::ComputeTimeCursorResponse,google/cloud/pubsublite/v1/topic_stats.proto#L153}
  ///
  /// [google.cloud.pubsublite.v1.ComputeTimeCursorRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/topic_stats.proto#L134}
  /// [google.cloud.pubsublite.v1.ComputeTimeCursorResponse]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/topic_stats.proto#L153}
  ///
  StatusOr<google::cloud::pubsublite::v1::ComputeTimeCursorResponse>
  ComputeTimeCursor(
      google::cloud::pubsublite::v1::ComputeTimeCursorRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<TopicStatsServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsublite
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_TOPIC_STATS_CLIENT_H
