// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/pubsublite/v1/topic_stats.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_INTERNAL_TOPIC_STATS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_INTERNAL_TOPIC_STATS_CONNECTION_IMPL_H

#include "google/cloud/pubsublite/internal/topic_stats_retry_traits.h"
#include "google/cloud/pubsublite/internal/topic_stats_stub.h"
#include "google/cloud/pubsublite/topic_stats_connection.h"
#include "google/cloud/pubsublite/topic_stats_connection_idempotency_policy.h"
#include "google/cloud/pubsublite/topic_stats_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsublite_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TopicStatsServiceConnectionImpl
    : public pubsublite::TopicStatsServiceConnection {
 public:
  ~TopicStatsServiceConnectionImpl() override = default;

  TopicStatsServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<pubsublite_internal::TopicStatsServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::pubsublite::v1::ComputeMessageStatsResponse>
  ComputeMessageStats(
      google::cloud::pubsublite::v1::ComputeMessageStatsRequest const& request)
      override;

  StatusOr<google::cloud::pubsublite::v1::ComputeHeadCursorResponse>
  ComputeHeadCursor(
      google::cloud::pubsublite::v1::ComputeHeadCursorRequest const& request)
      override;

  StatusOr<google::cloud::pubsublite::v1::ComputeTimeCursorResponse>
  ComputeTimeCursor(
      google::cloud::pubsublite::v1::ComputeTimeCursorRequest const& request)
      override;

 private:
  std::unique_ptr<pubsublite::TopicStatsServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<pubsublite::TopicStatsServiceRetryPolicyOption>()) {
      return options.get<pubsublite::TopicStatsServiceRetryPolicyOption>()
          ->clone();
    }
    return options_.get<pubsublite::TopicStatsServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<pubsublite::TopicStatsServiceBackoffPolicyOption>()) {
      return options.get<pubsublite::TopicStatsServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<pubsublite::TopicStatsServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<pubsublite::TopicStatsServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            pubsublite::TopicStatsServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<pubsublite::TopicStatsServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<pubsublite::TopicStatsServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<pubsublite_internal::TopicStatsServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsublite_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_INTERNAL_TOPIC_STATS_CONNECTION_IMPL_H
