// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/pubsublite/v1/admin.proto

#include "google/cloud/pubsublite/admin_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsublite {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AdminServiceConnectionIdempotencyPolicy::
    ~AdminServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultAdminServiceConnectionIdempotencyPolicy
    : public AdminServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultAdminServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<AdminServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultAdminServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency CreateTopic(
      google::cloud::pubsublite::v1::CreateTopicRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetTopic(
      google::cloud::pubsublite::v1::GetTopicRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetTopicPartitions(
      google::cloud::pubsublite::v1::GetTopicPartitionsRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListTopics(
      google::cloud::pubsublite::v1::ListTopicsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateTopic(
      google::cloud::pubsublite::v1::UpdateTopicRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteTopic(
      google::cloud::pubsublite::v1::DeleteTopicRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListTopicSubscriptions(
      google::cloud::pubsublite::v1::ListTopicSubscriptionsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateSubscription(
      google::cloud::pubsublite::v1::CreateSubscriptionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetSubscription(
      google::cloud::pubsublite::v1::GetSubscriptionRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListSubscriptions(
      google::cloud::pubsublite::v1::ListSubscriptionsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateSubscription(
      google::cloud::pubsublite::v1::UpdateSubscriptionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteSubscription(
      google::cloud::pubsublite::v1::DeleteSubscriptionRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SeekSubscription(
      google::cloud::pubsublite::v1::SeekSubscriptionRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateReservation(
      google::cloud::pubsublite::v1::CreateReservationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetReservation(
      google::cloud::pubsublite::v1::GetReservationRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListReservations(
      google::cloud::pubsublite::v1::ListReservationsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateReservation(
      google::cloud::pubsublite::v1::UpdateReservationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteReservation(
      google::cloud::pubsublite::v1::DeleteReservationRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListReservationTopics(
      google::cloud::pubsublite::v1::ListReservationTopicsRequest) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<AdminServiceConnectionIdempotencyPolicy>
MakeDefaultAdminServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultAdminServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsublite
}  // namespace cloud
}  // namespace google
