// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/pubsublite/v1/admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_ADMIN_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_ADMIN_CLIENT_H

#include "google/cloud/pubsublite/admin_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace pubsublite {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The service that a client application uses to manage topics and
/// subscriptions, such creating, listing, and deleting topics and
/// subscriptions.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AdminServiceClient {
 public:
  explicit AdminServiceClient(
      std::shared_ptr<AdminServiceConnection> connection, Options options = {});
  ~AdminServiceClient();

  //@{
  // @name Copy and move support
  AdminServiceClient(AdminServiceClient const&) = default;
  AdminServiceClient& operator=(AdminServiceClient const&) = default;
  AdminServiceClient(AdminServiceClient&&) = default;
  AdminServiceClient& operator=(AdminServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(AdminServiceClient const& a,
                         AdminServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AdminServiceClient const& a,
                         AdminServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a new topic.
  ///
  /// @param parent  Required. The parent location in which to create the topic.
  ///  Structured like `projects/{project_number}/locations/{location}`.
  /// @param topic  Required. Configuration of the topic to create. Its `name`
  /// field is ignored.
  /// @param topic_id  Required. The ID to use for the topic, which will become
  /// the final component of
  ///  the topic's name.
  ///  This value is structured like: `my-topic-name`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.CreateTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L227}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StatusOr<google::cloud::pubsublite::v1::Topic> CreateTopic(
      std::string const& parent,
      google::cloud::pubsublite::v1::Topic const& topic,
      std::string const& topic_id, Options options = {});

  ///
  /// Creates a new topic.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::CreateTopicRequest,google/cloud/pubsublite/v1/admin.proto#L227}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.CreateTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L227}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StatusOr<google::cloud::pubsublite::v1::Topic> CreateTopic(
      google::cloud::pubsublite::v1::CreateTopicRequest const& request,
      Options options = {});

  ///
  /// Returns the topic configuration.
  ///
  /// @param name  Required. The name of the topic whose configuration to
  /// return.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.GetTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L248}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StatusOr<google::cloud::pubsublite::v1::Topic> GetTopic(
      std::string const& name, Options options = {});

  ///
  /// Returns the topic configuration.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::GetTopicRequest,google/cloud/pubsublite/v1/admin.proto#L248}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.GetTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L248}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StatusOr<google::cloud::pubsublite::v1::Topic> GetTopic(
      google::cloud::pubsublite::v1::GetTopicRequest const& request,
      Options options = {});

  ///
  /// Returns the partition information for the requested topic.
  ///
  /// @param name  Required. The topic whose partition information to return.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::TopicPartitions,google/cloud/pubsublite/v1/admin.proto#L270}
  ///
  /// [google.cloud.pubsublite.v1.GetTopicPartitionsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L259}
  /// [google.cloud.pubsublite.v1.TopicPartitions]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L270}
  ///
  StatusOr<google::cloud::pubsublite::v1::TopicPartitions> GetTopicPartitions(
      std::string const& name, Options options = {});

  ///
  /// Returns the partition information for the requested topic.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::GetTopicPartitionsRequest,google/cloud/pubsublite/v1/admin.proto#L259}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::TopicPartitions,google/cloud/pubsublite/v1/admin.proto#L270}
  ///
  /// [google.cloud.pubsublite.v1.GetTopicPartitionsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L259}
  /// [google.cloud.pubsublite.v1.TopicPartitions]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L270}
  ///
  StatusOr<google::cloud::pubsublite::v1::TopicPartitions> GetTopicPartitions(
      google::cloud::pubsublite::v1::GetTopicPartitionsRequest const& request,
      Options options = {});

  ///
  /// Returns the list of topics for the given project.
  ///
  /// @param parent  Required. The parent whose topics are to be listed.
  ///  Structured like `projects/{project_number}/locations/{location}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.ListTopicsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L276}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StreamRange<google::cloud::pubsublite::v1::Topic> ListTopics(
      std::string const& parent, Options options = {});

  ///
  /// Returns the list of topics for the given project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ListTopicsRequest,google/cloud/pubsublite/v1/admin.proto#L276}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.ListTopicsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L276}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StreamRange<google::cloud::pubsublite::v1::Topic> ListTopics(
      google::cloud::pubsublite::v1::ListTopicsRequest request,
      Options options = {});

  ///
  /// Updates properties of the specified topic.
  ///
  /// @param topic  Required. The topic to update. Its `name` field must be
  /// populated.
  /// @param update_mask  Required. A mask specifying the topic fields to
  /// change.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.UpdateTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L311}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StatusOr<google::cloud::pubsublite::v1::Topic> UpdateTopic(
      google::cloud::pubsublite::v1::Topic const& topic,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates properties of the specified topic.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::UpdateTopicRequest,google/cloud/pubsublite/v1/admin.proto#L311}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Topic,google/cloud/pubsublite/v1/common.proto#L102}
  ///
  /// [google.cloud.pubsublite.v1.UpdateTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L311}
  /// [google.cloud.pubsublite.v1.Topic]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L102}
  ///
  StatusOr<google::cloud::pubsublite::v1::Topic> UpdateTopic(
      google::cloud::pubsublite::v1::UpdateTopicRequest const& request,
      Options options = {});

  ///
  /// Deletes the specified topic.
  ///
  /// @param name  Required. The name of the topic to delete.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.pubsublite.v1.DeleteTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L320}
  ///
  Status DeleteTopic(std::string const& name, Options options = {});

  ///
  /// Deletes the specified topic.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::DeleteTopicRequest,google/cloud/pubsublite/v1/admin.proto#L320}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.pubsublite.v1.DeleteTopicRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L320}
  ///
  Status DeleteTopic(
      google::cloud::pubsublite::v1::DeleteTopicRequest const& request,
      Options options = {});

  ///
  /// Lists the subscriptions attached to the specified topic.
  ///
  /// @param name  Required. The name of the topic whose subscriptions to list.
  /// @param options  Optional. Operation options.
  /// @return std::string
  ///
  /// [google.cloud.pubsublite.v1.ListTopicSubscriptionsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L331}
  ///
  StreamRange<std::string> ListTopicSubscriptions(std::string const& name,
                                                  Options options = {});

  ///
  /// Lists the subscriptions attached to the specified topic.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ListTopicSubscriptionsRequest,google/cloud/pubsublite/v1/admin.proto#L331}
  /// @param options  Optional. Operation options.
  /// @return std::string
  ///
  /// [google.cloud.pubsublite.v1.ListTopicSubscriptionsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L331}
  ///
  StreamRange<std::string> ListTopicSubscriptions(
      google::cloud::pubsublite::v1::ListTopicSubscriptionsRequest request,
      Options options = {});

  ///
  /// Creates a new subscription.
  ///
  /// @param parent  Required. The parent location in which to create the
  /// subscription.
  ///  Structured like `projects/{project_number}/locations/{location}`.
  /// @param subscription  Required. Configuration of the subscription to
  /// create. Its `name` field is ignored.
  /// @param subscription_id  Required. The ID to use for the subscription,
  /// which will become the final component
  ///  of the subscription's name.
  ///  This value is structured like: `my-sub-name`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.CreateSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L365}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StatusOr<google::cloud::pubsublite::v1::Subscription> CreateSubscription(
      std::string const& parent,
      google::cloud::pubsublite::v1::Subscription const& subscription,
      std::string const& subscription_id, Options options = {});

  ///
  /// Creates a new subscription.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::CreateSubscriptionRequest,google/cloud/pubsublite/v1/admin.proto#L365}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.CreateSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L365}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StatusOr<google::cloud::pubsublite::v1::Subscription> CreateSubscription(
      google::cloud::pubsublite::v1::CreateSubscriptionRequest const& request,
      Options options = {});

  ///
  /// Returns the subscription configuration.
  ///
  /// @param name  Required. The name of the subscription whose configuration to
  /// return.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.GetSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L391}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StatusOr<google::cloud::pubsublite::v1::Subscription> GetSubscription(
      std::string const& name, Options options = {});

  ///
  /// Returns the subscription configuration.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::GetSubscriptionRequest,google/cloud/pubsublite/v1/admin.proto#L391}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.GetSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L391}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StatusOr<google::cloud::pubsublite::v1::Subscription> GetSubscription(
      google::cloud::pubsublite::v1::GetSubscriptionRequest const& request,
      Options options = {});

  ///
  /// Returns the list of subscriptions for the given project.
  ///
  /// @param parent  Required. The parent whose subscriptions are to be listed.
  ///  Structured like `projects/{project_number}/locations/{location}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.ListSubscriptionsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L402}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StreamRange<google::cloud::pubsublite::v1::Subscription> ListSubscriptions(
      std::string const& parent, Options options = {});

  ///
  /// Returns the list of subscriptions for the given project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ListSubscriptionsRequest,google/cloud/pubsublite/v1/admin.proto#L402}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.ListSubscriptionsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L402}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StreamRange<google::cloud::pubsublite::v1::Subscription> ListSubscriptions(
      google::cloud::pubsublite::v1::ListSubscriptionsRequest request,
      Options options = {});

  ///
  /// Updates properties of the specified subscription.
  ///
  /// @param subscription  Required. The subscription to update. Its `name`
  /// field must be populated.
  ///  Topic field must not be populated.
  /// @param update_mask  Required. A mask specifying the subscription fields to
  /// change.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.UpdateSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L437}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StatusOr<google::cloud::pubsublite::v1::Subscription> UpdateSubscription(
      google::cloud::pubsublite::v1::Subscription const& subscription,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates properties of the specified subscription.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::UpdateSubscriptionRequest,google/cloud/pubsublite/v1/admin.proto#L437}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Subscription,google/cloud/pubsublite/v1/common.proto#L186}
  ///
  /// [google.cloud.pubsublite.v1.UpdateSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L437}
  /// [google.cloud.pubsublite.v1.Subscription]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L186}
  ///
  StatusOr<google::cloud::pubsublite::v1::Subscription> UpdateSubscription(
      google::cloud::pubsublite::v1::UpdateSubscriptionRequest const& request,
      Options options = {});

  ///
  /// Deletes the specified subscription.
  ///
  /// @param name  Required. The name of the subscription to delete.
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.pubsublite.v1.DeleteSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L447}
  ///
  Status DeleteSubscription(std::string const& name, Options options = {});

  ///
  /// Deletes the specified subscription.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::DeleteSubscriptionRequest,google/cloud/pubsublite/v1/admin.proto#L447}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.pubsublite.v1.DeleteSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L447}
  ///
  Status DeleteSubscription(
      google::cloud::pubsublite::v1::DeleteSubscriptionRequest const& request,
      Options options = {});

  ///
  /// Performs an out-of-band seek for a subscription to a specified target,
  /// which may be timestamps or named positions within the message backlog.
  /// Seek translates these targets to cursors for each partition and
  /// orchestrates subscribers to start consuming messages from these seek
  /// cursors.
  ///
  /// If an operation is returned, the seek has been registered and subscribers
  /// will eventually receive messages from the seek cursors (i.e. eventual
  /// consistency), as long as they are using a minimum supported client library
  /// version and not a system that tracks cursors independently of Pub/Sub Lite
  /// (e.g. Apache Beam, Dataflow, Spark). The seek operation will fail for
  /// unsupported clients.
  ///
  /// If clients would like to know when subscribers react to the seek (or not),
  /// they can poll the operation. The seek operation will succeed and complete
  /// once subscribers are ready to receive messages from the seek cursors for
  /// all partitions of the topic. This means that the seek operation will not
  /// complete until all subscribers come online.
  ///
  /// If the previous seek operation has not yet completed, it will be aborted
  /// and the new invocation of seek will supersede it.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::SeekSubscriptionRequest,google/cloud/pubsublite/v1/admin.proto#L458}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::SeekSubscriptionResponse,google/cloud/pubsublite/v1/admin.proto#L493}
  ///
  /// [google.cloud.pubsublite.v1.SeekSubscriptionRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L458}
  /// [google.cloud.pubsublite.v1.SeekSubscriptionResponse]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L493}
  ///
  future<StatusOr<google::cloud::pubsublite::v1::SeekSubscriptionResponse>>
  SeekSubscription(
      google::cloud::pubsublite::v1::SeekSubscriptionRequest const& request,
      Options options = {});

  ///
  /// Creates a new reservation.
  ///
  /// @param parent  Required. The parent location in which to create the
  /// reservation.
  ///  Structured like `projects/{project_number}/locations/{location}`.
  /// @param reservation  Required. Configuration of the reservation to create.
  /// Its `name` field is ignored.
  /// @param reservation_id  Required. The ID to use for the reservation, which
  /// will become the final component of
  ///  the reservation's name.
  ///  This value is structured like: `my-reservation-name`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.CreateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L516}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StatusOr<google::cloud::pubsublite::v1::Reservation> CreateReservation(
      std::string const& parent,
      google::cloud::pubsublite::v1::Reservation const& reservation,
      std::string const& reservation_id, Options options = {});

  ///
  /// Creates a new reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::CreateReservationRequest,google/cloud/pubsublite/v1/admin.proto#L516}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.CreateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L516}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StatusOr<google::cloud::pubsublite::v1::Reservation> CreateReservation(
      google::cloud::pubsublite::v1::CreateReservationRequest const& request,
      Options options = {});

  ///
  /// Returns the reservation configuration.
  ///
  /// @param name  Required. The name of the reservation whose configuration to
  /// return.
  ///  Structured like:
  ///  projects/{project_number}/locations/{location}/reservations/{reservation_id}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.GetReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L537}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StatusOr<google::cloud::pubsublite::v1::Reservation> GetReservation(
      std::string const& name, Options options = {});

  ///
  /// Returns the reservation configuration.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::GetReservationRequest,google/cloud/pubsublite/v1/admin.proto#L537}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.GetReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L537}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StatusOr<google::cloud::pubsublite::v1::Reservation> GetReservation(
      google::cloud::pubsublite::v1::GetReservationRequest const& request,
      Options options = {});

  ///
  /// Returns the list of reservations for the given project.
  ///
  /// @param parent  Required. The parent whose reservations are to be listed.
  ///  Structured like `projects/{project_number}/locations/{location}`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.ListReservationsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L550}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StreamRange<google::cloud::pubsublite::v1::Reservation> ListReservations(
      std::string const& parent, Options options = {});

  ///
  /// Returns the list of reservations for the given project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ListReservationsRequest,google/cloud/pubsublite/v1/admin.proto#L550}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.ListReservationsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L550}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StreamRange<google::cloud::pubsublite::v1::Reservation> ListReservations(
      google::cloud::pubsublite::v1::ListReservationsRequest request,
      Options options = {});

  ///
  /// Updates properties of the specified reservation.
  ///
  /// @param reservation  Required. The reservation to update. Its `name` field
  /// must be populated.
  /// @param update_mask  Required. A mask specifying the reservation fields to
  /// change.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.UpdateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L585}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StatusOr<google::cloud::pubsublite::v1::Reservation> UpdateReservation(
      google::cloud::pubsublite::v1::Reservation const& reservation,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates properties of the specified reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::UpdateReservationRequest,google/cloud/pubsublite/v1/admin.proto#L585}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::pubsublite::v1::Reservation,google/cloud/pubsublite/v1/common.proto#L80}
  ///
  /// [google.cloud.pubsublite.v1.UpdateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L585}
  /// [google.cloud.pubsublite.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/common.proto#L80}
  ///
  StatusOr<google::cloud::pubsublite::v1::Reservation> UpdateReservation(
      google::cloud::pubsublite::v1::UpdateReservationRequest const& request,
      Options options = {});

  ///
  /// Deletes the specified reservation.
  ///
  /// @param name  Required. The name of the reservation to delete.
  ///  Structured like:
  ///  projects/{project_number}/locations/{location}/reservations/{reservation_id}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.pubsublite.v1.DeleteReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L594}
  ///
  Status DeleteReservation(std::string const& name, Options options = {});

  ///
  /// Deletes the specified reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::DeleteReservationRequest,google/cloud/pubsublite/v1/admin.proto#L594}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.pubsublite.v1.DeleteReservationRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L594}
  ///
  Status DeleteReservation(
      google::cloud::pubsublite::v1::DeleteReservationRequest const& request,
      Options options = {});

  ///
  /// Lists the topics attached to the specified reservation.
  ///
  /// @param name  Required. The name of the reservation whose topics to list.
  ///  Structured like:
  ///  projects/{project_number}/locations/{location}/reservations/{reservation_id}
  /// @param options  Optional. Operation options.
  /// @return std::string
  ///
  /// [google.cloud.pubsublite.v1.ListReservationTopicsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L607}
  ///
  StreamRange<std::string> ListReservationTopics(std::string const& name,
                                                 Options options = {});

  ///
  /// Lists the topics attached to the specified reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::pubsublite::v1::ListReservationTopicsRequest,google/cloud/pubsublite/v1/admin.proto#L607}
  /// @param options  Optional. Operation options.
  /// @return std::string
  ///
  /// [google.cloud.pubsublite.v1.ListReservationTopicsRequest]:
  /// @googleapis_reference_link{google/cloud/pubsublite/v1/admin.proto#L607}
  ///
  StreamRange<std::string> ListReservationTopics(
      google::cloud::pubsublite::v1::ListReservationTopicsRequest request,
      Options options = {});

 private:
  std::shared_ptr<AdminServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsublite
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUBLITE_ADMIN_CLIENT_H
