// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/privateca/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_CERTIFICATE_AUTHORITY_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_CERTIFICATE_AUTHORITY_CLIENT_H

#include "google/cloud/privateca/certificate_authority_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace privateca {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// [Certificate Authority
/// Service][google.cloud.security.privateca.v1.CertificateAuthorityService]
/// manages private certificate authorities and issued certificates.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CertificateAuthorityServiceClient {
 public:
  explicit CertificateAuthorityServiceClient(
      std::shared_ptr<CertificateAuthorityServiceConnection> connection,
      Options options = {});
  ~CertificateAuthorityServiceClient();

  //@{
  // @name Copy and move support
  CertificateAuthorityServiceClient(CertificateAuthorityServiceClient const&) =
      default;
  CertificateAuthorityServiceClient& operator=(
      CertificateAuthorityServiceClient const&) = default;
  CertificateAuthorityServiceClient(CertificateAuthorityServiceClient&&) =
      default;
  CertificateAuthorityServiceClient& operator=(
      CertificateAuthorityServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(CertificateAuthorityServiceClient const& a,
                         CertificateAuthorityServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CertificateAuthorityServiceClient const& a,
                         CertificateAuthorityServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Create a new [Certificate][google.cloud.security.privateca.v1.Certificate]
  /// in a given Project, Location from a particular
  /// [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param parent  Required. The resource name of the
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] associated with the
  /// [Certificate][google.cloud.security.privateca.v1.Certificate],
  ///  in the format `projects/*/locations/*/caPools/*`.
  /// @param certificate  Required. A
  /// [Certificate][google.cloud.security.privateca.v1.Certificate] with initial
  /// field values.
  /// @param certificate_id  Optional. It must be unique within a location and
  /// match the regular
  ///  expression `[a-zA-Z0-9_-]{1,63}`. This field is required when using a
  ///  [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  ///  in the Enterprise [CertificateAuthority.Tier][], but is optional and its
  ///  value is ignored otherwise.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.CreateCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L364}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate>
  CreateCertificate(
      std::string const& parent,
      google::cloud::security::privateca::v1::Certificate const& certificate,
      std::string const& certificate_id, Options options = {});

  ///
  /// Create a new [Certificate][google.cloud.security.privateca.v1.Certificate]
  /// in a given Project, Location from a particular
  /// [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::CreateCertificateRequest,google/cloud/security/privateca/v1/service.proto#L364}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.CreateCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L364}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate>
  CreateCertificate(
      google::cloud::security::privateca::v1::CreateCertificateRequest const&
          request,
      Options options = {});

  ///
  /// Returns a [Certificate][google.cloud.security.privateca.v1.Certificate].
  ///
  /// @param name  Required. The
  /// [name][google.cloud.security.privateca.v1.Certificate.name] of the
  /// [Certificate][google.cloud.security.privateca.v1.Certificate] to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L419}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate> GetCertificate(
      std::string const& name, Options options = {});

  ///
  /// Returns a [Certificate][google.cloud.security.privateca.v1.Certificate].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::GetCertificateRequest,google/cloud/security/privateca/v1/service.proto#L419}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L419}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate> GetCertificate(
      google::cloud::security::privateca::v1::GetCertificateRequest const&
          request,
      Options options = {});

  ///
  /// Lists [Certificates][google.cloud.security.privateca.v1.Certificate].
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [Certificates][google.cloud.security.privateca.v1.Certificate], in the
  ///  format `projects/*/locations/*/caPools/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificatesRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L430}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StreamRange<google::cloud::security::privateca::v1::Certificate>
  ListCertificates(std::string const& parent, Options options = {});

  ///
  /// Lists [Certificates][google.cloud.security.privateca.v1.Certificate].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::ListCertificatesRequest,google/cloud/security/privateca/v1/service.proto#L430}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificatesRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L430}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StreamRange<google::cloud::security::privateca::v1::Certificate>
  ListCertificates(
      google::cloud::security::privateca::v1::ListCertificatesRequest request,
      Options options = {});

  ///
  /// Revoke a [Certificate][google.cloud.security.privateca.v1.Certificate].
  ///
  /// @param name  Required. The resource name for this
  /// [Certificate][google.cloud.security.privateca.v1.Certificate] in the
  ///  format
  ///  `projects/*/locations/*/caPools/*/certificates/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.RevokeCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L480}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate>
  RevokeCertificate(std::string const& name, Options options = {});

  ///
  /// Revoke a [Certificate][google.cloud.security.privateca.v1.Certificate].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::RevokeCertificateRequest,google/cloud/security/privateca/v1/service.proto#L480}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.RevokeCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L480}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate>
  RevokeCertificate(
      google::cloud::security::privateca::v1::RevokeCertificateRequest const&
          request,
      Options options = {});

  ///
  /// Update a [Certificate][google.cloud.security.privateca.v1.Certificate].
  /// Currently, the only field you can update is the
  /// [labels][google.cloud.security.privateca.v1.Certificate.labels] field.
  ///
  /// @param certificate  Required.
  /// [Certificate][google.cloud.security.privateca.v1.Certificate] with updated
  /// values.
  /// @param update_mask  Required. A list of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L511}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate>
  UpdateCertificate(
      google::cloud::security::privateca::v1::Certificate const& certificate,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a [Certificate][google.cloud.security.privateca.v1.Certificate].
  /// Currently, the only field you can update is the
  /// [labels][google.cloud.security.privateca.v1.Certificate.labels] field.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::UpdateCertificateRequest,google/cloud/security/privateca/v1/service.proto#L511}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::Certificate,google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L511}
  /// [google.cloud.security.privateca.v1.Certificate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L495}
  ///
  StatusOr<google::cloud::security::privateca::v1::Certificate>
  UpdateCertificate(
      google::cloud::security::privateca::v1::UpdateCertificateRequest const&
          request,
      Options options = {});

  ///
  /// Activate a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// that is in state
  /// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
  /// and is of type
  /// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
  /// After the parent Certificate Authority signs a certificate signing request
  /// from
  /// [FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCertificateAuthorityCsr],
  /// this method can complete the activation process.
  ///
  /// @param name  Required. The resource name for this
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in the
  ///  format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.ActivateCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L536}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  ActivateCertificateAuthority(std::string const& name, Options options = {});

  ///
  /// Activate a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// that is in state
  /// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
  /// and is of type
  /// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
  /// After the parent Certificate Authority signs a certificate signing request
  /// from
  /// [FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCertificateAuthorityCsr],
  /// this method can complete the activation process.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::ActivateCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L536}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.ActivateCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L536}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  ActivateCertificateAuthority(
      google::cloud::security::privateca::v1::
          ActivateCertificateAuthorityRequest const& request,
      Options options = {});

  ///
  /// Create a new
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in a given Project and Location.
  ///
  /// @param parent  Required. The resource name of the
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] associated with the
  ///  [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority],
  ///  in the format `projects/*/locations/*/caPools/*`.
  /// @param certificate_authority  Required. A
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// with initial field values.
  /// @param certificate_authority_id  Required. It must be unique within a
  /// location and match the regular
  ///  expression `[a-zA-Z0-9_-]{1,63}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.CreateCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L572}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  CreateCertificateAuthority(
      std::string const& parent,
      google::cloud::security::privateca::v1::CertificateAuthority const&
          certificate_authority,
      std::string const& certificate_authority_id, Options options = {});

  ///
  /// Create a new
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in a given Project and Location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::CreateCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L572}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.CreateCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L572}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  CreateCertificateAuthority(
      google::cloud::security::privateca::v1::
          CreateCertificateAuthorityRequest const& request,
      Options options = {});

  ///
  /// Disable a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param name  Required. The resource name for this
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in the
  ///  format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.DisableCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L608}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DisableCertificateAuthority(std::string const& name, Options options = {});

  ///
  /// Disable a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::DisableCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L608}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.DisableCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L608}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DisableCertificateAuthority(
      google::cloud::security::privateca::v1::
          DisableCertificateAuthorityRequest const& request,
      Options options = {});

  ///
  /// Enable a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param name  Required. The resource name for this
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in the
  ///  format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.EnableCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L636}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  EnableCertificateAuthority(std::string const& name, Options options = {});

  ///
  /// Enable a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::EnableCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L636}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.EnableCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L636}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  EnableCertificateAuthority(
      google::cloud::security::privateca::v1::
          EnableCertificateAuthorityRequest const& request,
      Options options = {});

  ///
  /// Fetch a certificate signing request (CSR) from a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// that is in state
  /// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
  /// and is of type
  /// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
  /// The CSR must then be signed by the desired parent Certificate Authority,
  /// which could be another
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// resource, or could be an on-prem certificate authority. See also
  /// [ActivateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.ActivateCertificateAuthority].
  ///
  /// @param name  Required. The resource name for this
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in the
  ///  format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::FetchCertificateAuthorityCsrResponse,google/cloud/security/privateca/v1/service.proto#L677}
  ///
  /// [google.cloud.security.privateca.v1.FetchCertificateAuthorityCsrRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L664}
  /// [google.cloud.security.privateca.v1.FetchCertificateAuthorityCsrResponse]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L677}
  ///
  StatusOr<google::cloud::security::privateca::v1::
               FetchCertificateAuthorityCsrResponse>
  FetchCertificateAuthorityCsr(std::string const& name, Options options = {});

  ///
  /// Fetch a certificate signing request (CSR) from a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// that is in state
  /// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
  /// and is of type
  /// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
  /// The CSR must then be signed by the desired parent Certificate Authority,
  /// which could be another
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// resource, or could be an on-prem certificate authority. See also
  /// [ActivateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.ActivateCertificateAuthority].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::FetchCertificateAuthorityCsrRequest,google/cloud/security/privateca/v1/service.proto#L664}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::FetchCertificateAuthorityCsrResponse,google/cloud/security/privateca/v1/service.proto#L677}
  ///
  /// [google.cloud.security.privateca.v1.FetchCertificateAuthorityCsrRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L664}
  /// [google.cloud.security.privateca.v1.FetchCertificateAuthorityCsrResponse]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L677}
  ///
  StatusOr<google::cloud::security::privateca::v1::
               FetchCertificateAuthorityCsrResponse>
  FetchCertificateAuthorityCsr(
      google::cloud::security::privateca::v1::
          FetchCertificateAuthorityCsrRequest const& request,
      Options options = {});

  ///
  /// Returns a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param name  Required. The
  /// [name][google.cloud.security.privateca.v1.CertificateAuthority.name] of
  /// the
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// to
  ///  get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L683}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>
  GetCertificateAuthority(std::string const& name, Options options = {});

  ///
  /// Returns a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::GetCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L683}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L683}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>
  GetCertificateAuthority(google::cloud::security::privateca::v1::
                              GetCertificateAuthorityRequest const& request,
                          Options options = {});

  ///
  /// Lists
  /// [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param parent  Required. The resource name of the
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] associated with the
  ///  [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority],
  ///  in the format `projects/*/locations/*/caPools/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificateAuthoritiesRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L696}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  StreamRange<google::cloud::security::privateca::v1::CertificateAuthority>
  ListCertificateAuthorities(std::string const& parent, Options options = {});

  ///
  /// Lists
  /// [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::ListCertificateAuthoritiesRequest,google/cloud/security/privateca/v1/service.proto#L696}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificateAuthoritiesRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L696}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  StreamRange<google::cloud::security::privateca::v1::CertificateAuthority>
  ListCertificateAuthorities(
      google::cloud::security::privateca::v1::ListCertificateAuthoritiesRequest
          request,
      Options options = {});

  ///
  /// Undelete a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// that has been deleted.
  ///
  /// @param name  Required. The resource name for this
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in the
  ///  format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.UndeleteCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L743}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UndeleteCertificateAuthority(std::string const& name, Options options = {});

  ///
  /// Undelete a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// that has been deleted.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::UndeleteCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L743}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.UndeleteCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L743}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UndeleteCertificateAuthority(
      google::cloud::security::privateca::v1::
          UndeleteCertificateAuthorityRequest const& request,
      Options options = {});

  ///
  /// Delete a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param name  Required. The resource name for this
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// in the
  ///  format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.DeleteCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L771}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DeleteCertificateAuthority(std::string const& name, Options options = {});

  ///
  /// Delete a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::DeleteCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L771}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.DeleteCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L771}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DeleteCertificateAuthority(
      google::cloud::security::privateca::v1::
          DeleteCertificateAuthorityRequest const& request,
      Options options = {});

  ///
  /// Update a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param certificate_authority  Required.
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// with updated values.
  /// @param update_mask  Required. A list of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L803}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UpdateCertificateAuthority(
      google::cloud::security::privateca::v1::CertificateAuthority const&
          certificate_authority,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::UpdateCertificateAuthorityRequest,google/cloud/security/privateca/v1/service.proto#L803}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateAuthority,google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateAuthorityRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L803}
  /// [google.cloud.security.privateca.v1.CertificateAuthority]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L37}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UpdateCertificateAuthority(
      google::cloud::security::privateca::v1::
          UpdateCertificateAuthorityRequest const& request,
      Options options = {});

  ///
  /// Create a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [CaPool][google.cloud.security.privateca.v1.CaPool], in the format
  ///  `projects/*/locations/*`.
  /// @param ca_pool  Required. A
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] with initial field
  /// values.
  /// @param ca_pool_id  Required. It must be unique within a location and match
  /// the regular
  ///  expression `[a-zA-Z0-9_-]{1,63}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.CreateCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L828}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> CreateCaPool(
      std::string const& parent,
      google::cloud::security::privateca::v1::CaPool const& ca_pool,
      std::string const& ca_pool_id, Options options = {});

  ///
  /// Create a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::CreateCaPoolRequest,google/cloud/security/privateca/v1/service.proto#L828}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.CreateCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L828}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> CreateCaPool(
      google::cloud::security::privateca::v1::CreateCaPoolRequest const&
          request,
      Options options = {});

  ///
  /// Update a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param ca_pool  Required.
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] with updated values.
  /// @param update_mask  Required. A list of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L863}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> UpdateCaPool(
      google::cloud::security::privateca::v1::CaPool const& ca_pool,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::UpdateCaPoolRequest,google/cloud/security/privateca/v1/service.proto#L863}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L863}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> UpdateCaPool(
      google::cloud::security::privateca::v1::UpdateCaPoolRequest const&
          request,
      Options options = {});

  ///
  /// Returns a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param name  Required. The
  /// [name][google.cloud.security.privateca.v1.CaPool.name] of the
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.GetCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L957}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  StatusOr<google::cloud::security::privateca::v1::CaPool> GetCaPool(
      std::string const& name, Options options = {});

  ///
  /// Returns a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::GetCaPoolRequest,google/cloud/security/privateca/v1/service.proto#L957}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.GetCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L957}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  StatusOr<google::cloud::security::privateca::v1::CaPool> GetCaPool(
      google::cloud::security::privateca::v1::GetCaPoolRequest const& request,
      Options options = {});

  ///
  /// Lists [CaPools][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [CaPools][google.cloud.security.privateca.v1.CaPool], in the format
  ///  `projects/*/locations/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.ListCaPoolsRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L969}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  StreamRange<google::cloud::security::privateca::v1::CaPool> ListCaPools(
      std::string const& parent, Options options = {});

  ///
  /// Lists [CaPools][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::ListCaPoolsRequest,google/cloud/security/privateca/v1/service.proto#L969}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CaPool,google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  /// [google.cloud.security.privateca.v1.ListCaPoolsRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L969}
  /// [google.cloud.security.privateca.v1.CaPool]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L243}
  ///
  StreamRange<google::cloud::security::privateca::v1::CaPool> ListCaPools(
      google::cloud::security::privateca::v1::ListCaPoolsRequest request,
      Options options = {});

  ///
  /// Delete a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param name  Required. The resource name for this
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] in the
  ///  format `projects/*/locations/*/caPools/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::OperationMetadata,google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  /// [google.cloud.security.privateca.v1.DeleteCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L888}
  /// [google.cloud.security.privateca.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCaPool(std::string const& name, Options options = {});

  ///
  /// Delete a [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::DeleteCaPoolRequest,google/cloud/security/privateca/v1/service.proto#L888}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::OperationMetadata,google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  /// [google.cloud.security.privateca.v1.DeleteCaPoolRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L888}
  /// [google.cloud.security.privateca.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCaPool(
      google::cloud::security::privateca::v1::DeleteCaPoolRequest const&
          request,
      Options options = {});

  ///
  /// FetchCaCerts returns the current trust anchor for the
  /// [CaPool][google.cloud.security.privateca.v1.CaPool]. This will include CA
  /// certificate chains for all ACTIVE
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// resources in the [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param ca_pool  Required. The resource name for the
  /// [CaPool][google.cloud.security.privateca.v1.CaPool] in the
  ///  format `projects/*/locations/*/caPools/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::FetchCaCertsResponse,google/cloud/security/privateca/v1/service.proto#L944}
  ///
  /// [google.cloud.security.privateca.v1.FetchCaCertsRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L916}
  /// [google.cloud.security.privateca.v1.FetchCaCertsResponse]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L944}
  ///
  StatusOr<google::cloud::security::privateca::v1::FetchCaCertsResponse>
  FetchCaCerts(std::string const& ca_pool, Options options = {});

  ///
  /// FetchCaCerts returns the current trust anchor for the
  /// [CaPool][google.cloud.security.privateca.v1.CaPool]. This will include CA
  /// certificate chains for all ACTIVE
  /// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
  /// resources in the [CaPool][google.cloud.security.privateca.v1.CaPool].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::FetchCaCertsRequest,google/cloud/security/privateca/v1/service.proto#L916}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::FetchCaCertsResponse,google/cloud/security/privateca/v1/service.proto#L944}
  ///
  /// [google.cloud.security.privateca.v1.FetchCaCertsRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L916}
  /// [google.cloud.security.privateca.v1.FetchCaCertsResponse]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L944}
  ///
  StatusOr<google::cloud::security::privateca::v1::FetchCaCertsResponse>
  FetchCaCerts(
      google::cloud::security::privateca::v1::FetchCaCertsRequest const&
          request,
      Options options = {});

  ///
  /// Returns a
  /// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
  ///
  /// @param name  Required. The
  /// [name][google.cloud.security.privateca.v1.CertificateRevocationList.name]
  /// of the
  ///  [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
  ///  to get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateRevocationList,google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateRevocationListRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1016}
  /// [google.cloud.security.privateca.v1.CertificateRevocationList]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>
  GetCertificateRevocationList(std::string const& name, Options options = {});

  ///
  /// Returns a
  /// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::GetCertificateRevocationListRequest,google/cloud/security/privateca/v1/service.proto#L1016}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateRevocationList,google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateRevocationListRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1016}
  /// [google.cloud.security.privateca.v1.CertificateRevocationList]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>
  GetCertificateRevocationList(
      google::cloud::security::privateca::v1::
          GetCertificateRevocationListRequest const& request,
      Options options = {});

  ///
  /// Lists
  /// [CertificateRevocationLists][google.cloud.security.privateca.v1.CertificateRevocationList].
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [CertificateRevocationLists][google.cloud.security.privateca.v1.CertificateRevocationList],
  ///  in the format
  ///  `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateRevocationList,google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificateRevocationListsRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1029}
  /// [google.cloud.security.privateca.v1.CertificateRevocationList]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  StreamRange<google::cloud::security::privateca::v1::CertificateRevocationList>
  ListCertificateRevocationLists(std::string const& parent,
                                 Options options = {});

  ///
  /// Lists
  /// [CertificateRevocationLists][google.cloud.security.privateca.v1.CertificateRevocationList].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::ListCertificateRevocationListsRequest,google/cloud/security/privateca/v1/service.proto#L1029}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateRevocationList,google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificateRevocationListsRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1029}
  /// [google.cloud.security.privateca.v1.CertificateRevocationList]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  StreamRange<google::cloud::security::privateca::v1::CertificateRevocationList>
  ListCertificateRevocationLists(
      google::cloud::security::privateca::v1::
          ListCertificateRevocationListsRequest request,
      Options options = {});

  ///
  /// Update a
  /// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
  ///
  /// @param certificate_revocation_list  Required.
  /// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList]
  /// with updated values.
  /// @param update_mask  Required. A list of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateRevocationList,google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateRevocationListRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1076}
  /// [google.cloud.security.privateca.v1.CertificateRevocationList]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  future<StatusOr<
      google::cloud::security::privateca::v1::CertificateRevocationList>>
  UpdateCertificateRevocationList(
      google::cloud::security::privateca::v1::CertificateRevocationList const&
          certificate_revocation_list,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a
  /// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::UpdateCertificateRevocationListRequest,google/cloud/security/privateca/v1/service.proto#L1076}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateRevocationList,google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateRevocationListRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1076}
  /// [google.cloud.security.privateca.v1.CertificateRevocationList]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L424}
  ///
  future<StatusOr<
      google::cloud::security::privateca::v1::CertificateRevocationList>>
  UpdateCertificateRevocationList(
      google::cloud::security::privateca::v1::
          UpdateCertificateRevocationListRequest const& request,
      Options options = {});

  ///
  /// Create a new
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
  /// in a given Project and Location.
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate],
  ///  in the format `projects/*/locations/*`.
  /// @param certificate_template  Required. A
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
  /// with initial field values.
  /// @param certificate_template_id  Required. It must be unique within a
  /// location and match the regular
  ///  expression `[a-zA-Z0-9_-]{1,63}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.CreateCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1101}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  CreateCertificateTemplate(
      std::string const& parent,
      google::cloud::security::privateca::v1::CertificateTemplate const&
          certificate_template,
      std::string const& certificate_template_id, Options options = {});

  ///
  /// Create a new
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
  /// in a given Project and Location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::CreateCertificateTemplateRequest,google/cloud/security/privateca/v1/service.proto#L1101}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.CreateCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1101}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  CreateCertificateTemplate(google::cloud::security::privateca::v1::
                                CreateCertificateTemplateRequest const& request,
                            Options options = {});

  ///
  /// DeleteCertificateTemplate deletes a
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param name  Required. The resource name for this
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
  /// in the format
  ///  `projects/*/locations/*/certificateTemplates/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::OperationMetadata,google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  /// [google.cloud.security.privateca.v1.DeleteCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1137}
  /// [google.cloud.security.privateca.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCertificateTemplate(std::string const& name, Options options = {});

  ///
  /// DeleteCertificateTemplate deletes a
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::DeleteCertificateTemplateRequest,google/cloud/security/privateca/v1/service.proto#L1137}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::OperationMetadata,google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  /// [google.cloud.security.privateca.v1.DeleteCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1137}
  /// [google.cloud.security.privateca.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1249}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCertificateTemplate(google::cloud::security::privateca::v1::
                                DeleteCertificateTemplateRequest const& request,
                            Options options = {});

  ///
  /// Returns a
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param name  Required. The
  /// [name][google.cloud.security.privateca.v1.CertificateTemplate.name] of the
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
  /// to
  ///  get.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1165}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>
  GetCertificateTemplate(std::string const& name, Options options = {});

  ///
  /// Returns a
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::GetCertificateTemplateRequest,google/cloud/security/privateca/v1/service.proto#L1165}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.GetCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1165}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>
  GetCertificateTemplate(google::cloud::security::privateca::v1::
                             GetCertificateTemplateRequest const& request,
                         Options options = {});

  ///
  /// Lists
  /// [CertificateTemplates][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param parent  Required. The resource name of the location associated with
  /// the
  ///  [CertificateTemplates][google.cloud.security.privateca.v1.CertificateTemplate],
  ///  in the format `projects/*/locations/*`.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificateTemplatesRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1178}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  StreamRange<google::cloud::security::privateca::v1::CertificateTemplate>
  ListCertificateTemplates(std::string const& parent, Options options = {});

  ///
  /// Lists
  /// [CertificateTemplates][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::ListCertificateTemplatesRequest,google/cloud/security/privateca/v1/service.proto#L1178}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.ListCertificateTemplatesRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1178}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  StreamRange<google::cloud::security::privateca::v1::CertificateTemplate>
  ListCertificateTemplates(
      google::cloud::security::privateca::v1::ListCertificateTemplatesRequest
          request,
      Options options = {});

  ///
  /// Update a
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param certificate_template  Required.
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
  /// with updated values.
  /// @param update_mask  Required. A list of fields to be updated in this
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1225}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  UpdateCertificateTemplate(
      google::cloud::security::privateca::v1::CertificateTemplate const&
          certificate_template,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a
  /// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
  ///
  /// @param request
  /// @googleapis_link{google::cloud::security::privateca::v1::UpdateCertificateTemplateRequest,google/cloud/security/privateca/v1/service.proto#L1225}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::security::privateca::v1::CertificateTemplate,google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  /// [google.cloud.security.privateca.v1.UpdateCertificateTemplateRequest]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/service.proto#L1225}
  /// [google.cloud.security.privateca.v1.CertificateTemplate]:
  /// @googleapis_reference_link{google/cloud/security/privateca/v1/resources.proto#L590}
  ///
  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  UpdateCertificateTemplate(google::cloud::security::privateca::v1::
                                UpdateCertificateTemplateRequest const& request,
                            Options options = {});

 private:
  std::shared_ptr<CertificateAuthorityServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privateca
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_CERTIFICATE_AUTHORITY_CLIENT_H
