// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policytroubleshooter/v1/checker.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYTROUBLESHOOTER_INTERNAL_IAM_CHECKER_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYTROUBLESHOOTER_INTERNAL_IAM_CHECKER_CONNECTION_IMPL_H

#include "google/cloud/policytroubleshooter/iam_checker_connection.h"
#include "google/cloud/policytroubleshooter/iam_checker_connection_idempotency_policy.h"
#include "google/cloud/policytroubleshooter/iam_checker_options.h"
#include "google/cloud/policytroubleshooter/internal/iam_checker_retry_traits.h"
#include "google/cloud/policytroubleshooter/internal/iam_checker_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace policytroubleshooter_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class IamCheckerConnectionImpl
    : public policytroubleshooter::IamCheckerConnection {
 public:
  ~IamCheckerConnectionImpl() override = default;

  IamCheckerConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<policytroubleshooter_internal::IamCheckerStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<
      google::cloud::policytroubleshooter::v1::TroubleshootIamPolicyResponse>
  TroubleshootIamPolicy(
      google::cloud::policytroubleshooter::v1::
          TroubleshootIamPolicyRequest const& request) override;

 private:
  std::unique_ptr<policytroubleshooter::IamCheckerRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<policytroubleshooter::IamCheckerRetryPolicyOption>()) {
      return options.get<policytroubleshooter::IamCheckerRetryPolicyOption>()
          ->clone();
    }
    return options_.get<policytroubleshooter::IamCheckerRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<policytroubleshooter::IamCheckerBackoffPolicyOption>()) {
      return options.get<policytroubleshooter::IamCheckerBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<policytroubleshooter::IamCheckerBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<policytroubleshooter::IamCheckerConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<policytroubleshooter::
                        IamCheckerConnectionIdempotencyPolicyOption>()) {
      return options
          .get<policytroubleshooter::
                   IamCheckerConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<
            policytroubleshooter::IamCheckerConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<policytroubleshooter_internal::IamCheckerStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policytroubleshooter_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_POLICYTROUBLESHOOTER_INTERNAL_IAM_CHECKER_CONNECTION_IMPL_H
