// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policytroubleshooter/v1/checker.proto

#include "google/cloud/policytroubleshooter/iam_checker_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace policytroubleshooter {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

IamCheckerConnectionIdempotencyPolicy::
    ~IamCheckerConnectionIdempotencyPolicy() = default;

namespace {
class DefaultIamCheckerConnectionIdempotencyPolicy
    : public IamCheckerConnectionIdempotencyPolicy {
 public:
  ~DefaultIamCheckerConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<IamCheckerConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultIamCheckerConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency TroubleshootIamPolicy(
      google::cloud::policytroubleshooter::v1::
          TroubleshootIamPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<IamCheckerConnectionIdempotencyPolicy>
MakeDefaultIamCheckerConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultIamCheckerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policytroubleshooter
}  // namespace cloud
}  // namespace google
