// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policytroubleshooter/v1/checker.proto

#include "google/cloud/policytroubleshooter/iam_checker_connection.h"
#include "google/cloud/policytroubleshooter/iam_checker_options.h"
#include "google/cloud/policytroubleshooter/internal/iam_checker_connection_impl.h"
#include "google/cloud/policytroubleshooter/internal/iam_checker_option_defaults.h"
#include "google/cloud/policytroubleshooter/internal/iam_checker_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace policytroubleshooter {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IamCheckerConnection::~IamCheckerConnection() = default;

StatusOr<google::cloud::policytroubleshooter::v1::TroubleshootIamPolicyResponse>
IamCheckerConnection::TroubleshootIamPolicy(
    google::cloud::policytroubleshooter::v1::
        TroubleshootIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<IamCheckerConnection> MakeIamCheckerConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 IamCheckerPolicyOptionList>(options, __func__);
  options = policytroubleshooter_internal::IamCheckerDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = policytroubleshooter_internal::CreateDefaultIamCheckerStub(
      background->cq(), options);
  return std::make_shared<
      policytroubleshooter_internal::IamCheckerConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policytroubleshooter
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace policytroubleshooter_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<policytroubleshooter::IamCheckerConnection>
MakeIamCheckerConnection(std::shared_ptr<IamCheckerStub> stub,
                         Options options) {
  options = IamCheckerDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      policytroubleshooter_internal::IamCheckerConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policytroubleshooter_internal
}  // namespace cloud
}  // namespace google
