// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policytroubleshooter/v1/checker.proto

#include "google/cloud/policytroubleshooter/iam_checker_client.h"
#include "google/cloud/policytroubleshooter/internal/iam_checker_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace policytroubleshooter {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IamCheckerClient::IamCheckerClient(
    std::shared_ptr<IamCheckerConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          policytroubleshooter_internal::IamCheckerDefaultOptions(
              connection_->options()))) {}
IamCheckerClient::~IamCheckerClient() = default;

StatusOr<google::cloud::policytroubleshooter::v1::TroubleshootIamPolicyResponse>
IamCheckerClient::TroubleshootIamPolicy(
    google::cloud::policytroubleshooter::v1::TroubleshootIamPolicyRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->TroubleshootIamPolicy(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policytroubleshooter
}  // namespace cloud
}  // namespace google
