// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/oslogin/v1/oslogin.proto

#include "google/cloud/oslogin/os_login_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace oslogin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

OsLoginServiceConnectionIdempotencyPolicy::
    ~OsLoginServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultOsLoginServiceConnectionIdempotencyPolicy
    : public OsLoginServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultOsLoginServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<OsLoginServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultOsLoginServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency DeletePosixAccount(
      google::cloud::oslogin::v1::DeletePosixAccountRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteSshPublicKey(
      google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetLoginProfile(
      google::cloud::oslogin::v1::GetLoginProfileRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetSshPublicKey(
      google::cloud::oslogin::v1::GetSshPublicKeyRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ImportSshPublicKey(
      google::cloud::oslogin::v1::ImportSshPublicKeyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateSshPublicKey(
      google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<OsLoginServiceConnectionIdempotencyPolicy>
MakeDefaultOsLoginServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultOsLoginServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace oslogin
}  // namespace cloud
}  // namespace google
