// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/oslogin/v1/oslogin.proto

#include "google/cloud/oslogin/internal/os_login_auth_decorator.h"
#include <google/cloud/oslogin/v1/oslogin.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace oslogin_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

OsLoginServiceAuth::OsLoginServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<OsLoginServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

Status OsLoginServiceAuth::DeletePosixAccount(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::DeletePosixAccountRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeletePosixAccount(context, request);
}

Status OsLoginServiceAuth::DeleteSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteSshPublicKey(context, request);
}

StatusOr<google::cloud::oslogin::v1::LoginProfile>
OsLoginServiceAuth::GetLoginProfile(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::GetLoginProfileRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetLoginProfile(context, request);
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceAuth::GetSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::GetSshPublicKeyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetSshPublicKey(context, request);
}

StatusOr<google::cloud::oslogin::v1::ImportSshPublicKeyResponse>
OsLoginServiceAuth::ImportSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::ImportSshPublicKeyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ImportSshPublicKey(context, request);
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceAuth::UpdateSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateSshPublicKey(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace oslogin_internal
}  // namespace cloud
}  // namespace google
