// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_service.proto

#include "google/cloud/osconfig/os_config_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

OsConfigServiceConnectionIdempotencyPolicy::
    ~OsConfigServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultOsConfigServiceConnectionIdempotencyPolicy
    : public OsConfigServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultOsConfigServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<OsConfigServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultOsConfigServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ExecutePatchJob(
      google::cloud::osconfig::v1::ExecutePatchJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetPatchJob(
      google::cloud::osconfig::v1::GetPatchJobRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CancelPatchJob(
      google::cloud::osconfig::v1::CancelPatchJobRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListPatchJobs(
      google::cloud::osconfig::v1::ListPatchJobsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListPatchJobInstanceDetails(
      google::cloud::osconfig::v1::ListPatchJobInstanceDetailsRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreatePatchDeployment(
      google::cloud::osconfig::v1::CreatePatchDeploymentRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetPatchDeployment(
      google::cloud::osconfig::v1::GetPatchDeploymentRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListPatchDeployments(
      google::cloud::osconfig::v1::ListPatchDeploymentsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency DeletePatchDeployment(
      google::cloud::osconfig::v1::DeletePatchDeploymentRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<OsConfigServiceConnectionIdempotencyPolicy>
MakeDefaultOsConfigServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultOsConfigServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig
}  // namespace cloud
}  // namespace google
