// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_service.proto

#include "google/cloud/osconfig/os_config_client.h"
#include "google/cloud/osconfig/internal/os_config_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

OsConfigServiceClient::OsConfigServiceClient(
    std::shared_ptr<OsConfigServiceConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), osconfig_internal::OsConfigServiceDefaultOptions(
                                  connection_->options()))) {}
OsConfigServiceClient::~OsConfigServiceClient() = default;

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceClient::ExecutePatchJob(
    google::cloud::osconfig::v1::ExecutePatchJobRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ExecutePatchJob(request);
}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceClient::GetPatchJob(std::string const& name, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::osconfig::v1::GetPatchJobRequest request;
  request.set_name(name);
  return connection_->GetPatchJob(request);
}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceClient::GetPatchJob(
    google::cloud::osconfig::v1::GetPatchJobRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetPatchJob(request);
}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceClient::CancelPatchJob(
    google::cloud::osconfig::v1::CancelPatchJobRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CancelPatchJob(request);
}

StreamRange<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceClient::ListPatchJobs(std::string const& parent,
                                     Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::osconfig::v1::ListPatchJobsRequest request;
  request.set_parent(parent);
  return connection_->ListPatchJobs(request);
}

StreamRange<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceClient::ListPatchJobs(
    google::cloud::osconfig::v1::ListPatchJobsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListPatchJobs(std::move(request));
}

StreamRange<google::cloud::osconfig::v1::PatchJobInstanceDetails>
OsConfigServiceClient::ListPatchJobInstanceDetails(std::string const& parent,
                                                   Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::osconfig::v1::ListPatchJobInstanceDetailsRequest request;
  request.set_parent(parent);
  return connection_->ListPatchJobInstanceDetails(request);
}

StreamRange<google::cloud::osconfig::v1::PatchJobInstanceDetails>
OsConfigServiceClient::ListPatchJobInstanceDetails(
    google::cloud::osconfig::v1::ListPatchJobInstanceDetailsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListPatchJobInstanceDetails(std::move(request));
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceClient::CreatePatchDeployment(
    std::string const& parent,
    google::cloud::osconfig::v1::PatchDeployment const& patch_deployment,
    std::string const& patch_deployment_id, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::osconfig::v1::CreatePatchDeploymentRequest request;
  request.set_parent(parent);
  *request.mutable_patch_deployment() = patch_deployment;
  request.set_patch_deployment_id(patch_deployment_id);
  return connection_->CreatePatchDeployment(request);
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceClient::CreatePatchDeployment(
    google::cloud::osconfig::v1::CreatePatchDeploymentRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreatePatchDeployment(request);
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceClient::GetPatchDeployment(std::string const& name,
                                          Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::osconfig::v1::GetPatchDeploymentRequest request;
  request.set_name(name);
  return connection_->GetPatchDeployment(request);
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceClient::GetPatchDeployment(
    google::cloud::osconfig::v1::GetPatchDeploymentRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetPatchDeployment(request);
}

StreamRange<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceClient::ListPatchDeployments(std::string const& parent,
                                            Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::osconfig::v1::ListPatchDeploymentsRequest request;
  request.set_parent(parent);
  return connection_->ListPatchDeployments(request);
}

StreamRange<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceClient::ListPatchDeployments(
    google::cloud::osconfig::v1::ListPatchDeploymentsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListPatchDeployments(std::move(request));
}

Status OsConfigServiceClient::DeletePatchDeployment(std::string const& name,
                                                    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::cloud::osconfig::v1::DeletePatchDeploymentRequest request;
  request.set_name(name);
  return connection_->DeletePatchDeployment(request);
}

Status OsConfigServiceClient::DeletePatchDeployment(
    google::cloud::osconfig::v1::DeletePatchDeploymentRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeletePatchDeployment(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig
}  // namespace cloud
}  // namespace google
