// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_INTERNAL_AGENT_ENDPOINT_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_INTERNAL_AGENT_ENDPOINT_CONNECTION_IMPL_H

#include "google/cloud/osconfig/agent_endpoint_connection.h"
#include "google/cloud/osconfig/agent_endpoint_connection_idempotency_policy.h"
#include "google/cloud/osconfig/agent_endpoint_options.h"
#include "google/cloud/osconfig/internal/agent_endpoint_retry_traits.h"
#include "google/cloud/osconfig/internal/agent_endpoint_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AgentEndpointServiceConnectionImpl
    : public osconfig::AgentEndpointServiceConnection {
 public:
  ~AgentEndpointServiceConnectionImpl() override = default;

  AgentEndpointServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<osconfig_internal::AgentEndpointServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::osconfig::agentendpoint::v1::
                  ReceiveTaskNotificationResponse>
  ReceiveTaskNotification(
      google::cloud::osconfig::agentendpoint::v1::
          ReceiveTaskNotificationRequest const& request) override;

  StatusOr<google::cloud::osconfig::agentendpoint::v1::StartNextTaskResponse>
  StartNextTask(
      google::cloud::osconfig::agentendpoint::v1::StartNextTaskRequest const&
          request) override;

  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressResponse>
  ReportTaskProgress(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskProgressRequest const& request) override;

  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteResponse>
  ReportTaskComplete(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskCompleteRequest const& request) override;

  StatusOr<google::cloud::osconfig::agentendpoint::v1::RegisterAgentResponse>
  RegisterAgent(
      google::cloud::osconfig::agentendpoint::v1::RegisterAgentRequest const&
          request) override;

  StatusOr<google::cloud::osconfig::agentendpoint::v1::ReportInventoryResponse>
  ReportInventory(
      google::cloud::osconfig::agentendpoint::v1::ReportInventoryRequest const&
          request) override;

 private:
  std::unique_ptr<osconfig::AgentEndpointServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<osconfig::AgentEndpointServiceRetryPolicyOption>()) {
      return options.get<osconfig::AgentEndpointServiceRetryPolicyOption>()
          ->clone();
    }
    return options_.get<osconfig::AgentEndpointServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<osconfig::AgentEndpointServiceBackoffPolicyOption>()) {
      return options.get<osconfig::AgentEndpointServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<osconfig::AgentEndpointServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<osconfig::AgentEndpointServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<osconfig::
                     AgentEndpointServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<
              osconfig::AgentEndpointServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<osconfig::AgentEndpointServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<osconfig_internal::AgentEndpointServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_INTERNAL_AGENT_ENDPOINT_CONNECTION_IMPL_H
