// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

#include "google/cloud/osconfig/agent_endpoint_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AgentEndpointServiceConnectionIdempotencyPolicy::
    ~AgentEndpointServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultAgentEndpointServiceConnectionIdempotencyPolicy
    : public AgentEndpointServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultAgentEndpointServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<AgentEndpointServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultAgentEndpointServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency StartNextTask(
      google::cloud::osconfig::agentendpoint::v1::StartNextTaskRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ReportTaskProgress(
      google::cloud::osconfig::agentendpoint::v1::
          ReportTaskProgressRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ReportTaskComplete(
      google::cloud::osconfig::agentendpoint::v1::
          ReportTaskCompleteRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RegisterAgent(
      google::cloud::osconfig::agentendpoint::v1::RegisterAgentRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ReportInventory(
      google::cloud::osconfig::agentendpoint::v1::ReportInventoryRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<AgentEndpointServiceConnectionIdempotencyPolicy>
MakeDefaultAgentEndpointServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultAgentEndpointServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig
}  // namespace cloud
}  // namespace google
