// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENT_ENDPOINT_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENT_ENDPOINT_CONNECTION_H

#include "google/cloud/osconfig/agent_endpoint_connection_idempotency_policy.h"
#include "google/cloud/osconfig/internal/agent_endpoint_retry_traits.h"
#include "google/cloud/osconfig/internal/agent_endpoint_stub.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using AgentEndpointServiceRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        osconfig_internal::AgentEndpointServiceRetryTraits>;

using AgentEndpointServiceLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        osconfig_internal::AgentEndpointServiceRetryTraits>;

using AgentEndpointServiceLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        osconfig_internal::AgentEndpointServiceRetryTraits>;

void AgentEndpointServiceReceiveTaskNotificationStreamingUpdater(
    google::cloud::osconfig::agentendpoint::v1::
        ReceiveTaskNotificationResponse const& response,
    google::cloud::osconfig::agentendpoint::v1::ReceiveTaskNotificationRequest&
        request);

class AgentEndpointServiceConnection {
 public:
  virtual ~AgentEndpointServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::osconfig::agentendpoint::v1::
                          ReceiveTaskNotificationResponse>
  ReceiveTaskNotification(google::cloud::osconfig::agentendpoint::v1::
                              ReceiveTaskNotificationRequest const& request);

  virtual StatusOr<
      google::cloud::osconfig::agentendpoint::v1::StartNextTaskResponse>
  StartNextTask(
      google::cloud::osconfig::agentendpoint::v1::StartNextTaskRequest const&
          request);

  virtual StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressResponse>
  ReportTaskProgress(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskProgressRequest const& request);

  virtual StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteResponse>
  ReportTaskComplete(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskCompleteRequest const& request);

  virtual StatusOr<
      google::cloud::osconfig::agentendpoint::v1::RegisterAgentResponse>
  RegisterAgent(
      google::cloud::osconfig::agentendpoint::v1::RegisterAgentRequest const&
          request);

  virtual StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportInventoryResponse>
  ReportInventory(
      google::cloud::osconfig::agentendpoint::v1::ReportInventoryRequest const&
          request);
};

std::shared_ptr<AgentEndpointServiceConnection>
MakeAgentEndpointServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace osconfig_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<osconfig::AgentEndpointServiceConnection>
MakeAgentEndpointServiceConnection(
    std::shared_ptr<AgentEndpointServiceStub> stub, Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENT_ENDPOINT_CONNECTION_H
