// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENT_ENDPOINT_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENT_ENDPOINT_CLIENT_H

#include "google/cloud/osconfig/agent_endpoint_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// OS Config agent endpoint API.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AgentEndpointServiceClient {
 public:
  explicit AgentEndpointServiceClient(
      std::shared_ptr<AgentEndpointServiceConnection> connection,
      Options options = {});
  ~AgentEndpointServiceClient();

  //@{
  // @name Copy and move support
  AgentEndpointServiceClient(AgentEndpointServiceClient const&) = default;
  AgentEndpointServiceClient& operator=(AgentEndpointServiceClient const&) =
      default;
  AgentEndpointServiceClient(AgentEndpointServiceClient&&) = default;
  AgentEndpointServiceClient& operator=(AgentEndpointServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(AgentEndpointServiceClient const& a,
                         AgentEndpointServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AgentEndpointServiceClient const& a,
                         AgentEndpointServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Stream established by client to receive Task notifications.
  ///
  /// @param instance_id_token  Required. This is the Compute Engine instance
  /// identity token described in
  ///  https://cloud.google.com/compute/docs/instances/verifying-instance-identity
  ///  where the audience is 'osconfig.googleapis.com' and the format is 'full'.
  /// @param agent_version  Required. The version of the agent making the
  /// request.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReceiveTaskNotificationResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L86}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L74}
  /// [google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L86}
  ///
  StreamRange<google::cloud::osconfig::agentendpoint::v1::
                  ReceiveTaskNotificationResponse>
  ReceiveTaskNotification(std::string const& instance_id_token,
                          std::string const& agent_version,
                          Options options = {});

  ///
  /// Stream established by client to receive Task notifications.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReceiveTaskNotificationRequest,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L74}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReceiveTaskNotificationResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L86}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L74}
  /// [google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L86}
  ///
  StreamRange<google::cloud::osconfig::agentendpoint::v1::
                  ReceiveTaskNotificationResponse>
  ReceiveTaskNotification(google::cloud::osconfig::agentendpoint::v1::
                              ReceiveTaskNotificationRequest const& request,
                          Options options = {});

  ///
  /// Signals the start of a task execution and returns the task info.
  ///
  /// @param instance_id_token  Required. This is the Compute Engine instance
  /// identity token described in
  ///  https://cloud.google.com/compute/docs/instances/verifying-instance-identity
  ///  where the audience is 'osconfig.googleapis.com' and the format is 'full'.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::StartNextTaskResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L97}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.StartNextTaskRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L89}
  /// [google.cloud.osconfig.agentendpoint.v1.StartNextTaskResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L97}
  ///
  StatusOr<google::cloud::osconfig::agentendpoint::v1::StartNextTaskResponse>
  StartNextTask(std::string const& instance_id_token, Options options = {});

  ///
  /// Signals the start of a task execution and returns the task info.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::StartNextTaskRequest,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L89}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::StartNextTaskResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L97}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.StartNextTaskRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L89}
  /// [google.cloud.osconfig.agentendpoint.v1.StartNextTaskResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L97}
  ///
  StatusOr<google::cloud::osconfig::agentendpoint::v1::StartNextTaskResponse>
  StartNextTask(
      google::cloud::osconfig::agentendpoint::v1::StartNextTaskRequest const&
          request,
      Options options = {});

  ///
  /// Signals an intermediary progress checkpoint in task execution.
  ///
  /// @param instance_id_token  Required. This is the Compute Engine instance
  /// identity token described in
  ///  https://cloud.google.com/compute/docs/instances/verifying-instance-identity
  ///  where the audience is 'osconfig.googleapis.com' and the format is 'full'.
  /// @param task_id  Required. Unique identifier of the task this applies to.
  /// @param task_type  Required. The type of task to report progress on.
  ///  Progress must include the appropriate message based on this enum as
  ///  specified below:
  ///  APPLY_PATCHES = ApplyPatchesTaskProgress
  ///  EXEC_STEP = Progress not supported for this type.
  ///  APPLY_CONFIG_TASK = ApplyConfigTaskProgress
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L136}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L104}
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L136}
  ///
  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressResponse>
  ReportTaskProgress(
      std::string const& instance_id_token, std::string const& task_id,
      google::cloud::osconfig::agentendpoint::v1::TaskType task_type,
      Options options = {});

  ///
  /// Signals an intermediary progress checkpoint in task execution.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressRequest,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L104}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L136}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L104}
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L136}
  ///
  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressResponse>
  ReportTaskProgress(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskProgressRequest const& request,
                     Options options = {});

  ///
  /// Signals that the task execution is complete and optionally returns the
  /// next task.
  ///
  /// @param instance_id_token  Required. This is the Compute Engine instance
  /// identity token described in
  ///  https://cloud.google.com/compute/docs/instances/verifying-instance-identity
  ///  where the audience is 'osconfig.googleapis.com' and the format is 'full'.
  /// @param task_id  Required. Unique identifier of the task this applies to.
  /// @param task_type  Required. The type of task to report completed.
  ///  Output must include the appropriate message based on this enum as
  ///  specified below:
  ///  APPLY_PATCHES = ApplyPatchesTaskOutput
  ///  EXEC_STEP = ExecStepTaskOutput
  ///  APPLY_CONFIG_TASK = ApplyConfigTaskOutput
  /// @param error_message  Descriptive error message if the task execution
  /// ended in error.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L177}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L142}
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L177}
  ///
  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteResponse>
  ReportTaskComplete(
      std::string const& instance_id_token, std::string const& task_id,
      google::cloud::osconfig::agentendpoint::v1::TaskType task_type,
      std::string const& error_message, Options options = {});

  ///
  /// Signals that the task execution is complete and optionally returns the
  /// next task.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteRequest,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L142}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L177}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L142}
  /// [google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L177}
  ///
  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteResponse>
  ReportTaskComplete(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskCompleteRequest const& request,
                     Options options = {});

  ///
  /// Registers the agent running on the VM.
  ///
  /// @param instance_id_token  Required. This is the Compute Engine instance
  /// identity token described in
  ///  https://cloud.google.com/compute/docs/instances/verifying-instance-identity
  ///  where the audience is 'osconfig.googleapis.com' and the format is 'full'.
  /// @param agent_version  Required. The version of the agent.
  /// @param supported_capabilities  Required. The capabilities supported by the
  /// agent. Supported values are:
  ///  PATCH_GA
  ///  GUEST_POLICY_BETA
  ///  CONFIG_V1
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::RegisterAgentResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L212}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.RegisterAgentRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L180}
  /// [google.cloud.osconfig.agentendpoint.v1.RegisterAgentResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L212}
  ///
  StatusOr<google::cloud::osconfig::agentendpoint::v1::RegisterAgentResponse>
  RegisterAgent(std::string const& instance_id_token,
                std::string const& agent_version,
                std::vector<std::string> const& supported_capabilities,
                Options options = {});

  ///
  /// Registers the agent running on the VM.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::RegisterAgentRequest,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L180}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::RegisterAgentResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L212}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.RegisterAgentRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L180}
  /// [google.cloud.osconfig.agentendpoint.v1.RegisterAgentResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L212}
  ///
  StatusOr<google::cloud::osconfig::agentendpoint::v1::RegisterAgentResponse>
  RegisterAgent(
      google::cloud::osconfig::agentendpoint::v1::RegisterAgentRequest const&
          request,
      Options options = {});

  ///
  /// Reports the VMs current inventory.
  ///
  /// @param instance_id_token  Required. This is the Compute Engine instance
  /// identity token described in
  ///  https://cloud.google.com/compute/docs/instances/verifying-instance-identity
  ///  where the audience is 'osconfig.googleapis.com' and the format is 'full'.
  /// @param inventory_checksum  Required. This is a client created checksum
  /// that should be generated based
  ///  on the contents of the reported inventory.  This will be used by the
  ///  service to determine if it has the latest version of inventory.
  /// @param inventory  Optional. This is the details of the inventory.  Should
  /// only be provided if
  ///  the inventory has changed since the last report, or if instructed by the
  ///  service to provide full inventory.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportInventoryResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L233}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReportInventoryRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L215}
  /// [google.cloud.osconfig.agentendpoint.v1.ReportInventoryResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L233}
  ///
  StatusOr<google::cloud::osconfig::agentendpoint::v1::ReportInventoryResponse>
  ReportInventory(
      std::string const& instance_id_token,
      std::string const& inventory_checksum,
      google::cloud::osconfig::agentendpoint::v1::Inventory const& inventory,
      Options options = {});

  ///
  /// Reports the VMs current inventory.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportInventoryRequest,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L215}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::osconfig::agentendpoint::v1::ReportInventoryResponse,google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L233}
  ///
  /// [google.cloud.osconfig.agentendpoint.v1.ReportInventoryRequest]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L215}
  /// [google.cloud.osconfig.agentendpoint.v1.ReportInventoryResponse]:
  /// @googleapis_reference_link{google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto#L233}
  ///
  StatusOr<google::cloud::osconfig::agentendpoint::v1::ReportInventoryResponse>
  ReportInventory(
      google::cloud::osconfig::agentendpoint::v1::ReportInventoryRequest const&
          request,
      Options options = {});

 private:
  std::shared_ptr<AgentEndpointServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENT_ENDPOINT_CLIENT_H
