// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ORGPOLICY_ORG_POLICY_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ORGPOLICY_ORG_POLICY_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/cloud/orgpolicy/v2/orgpolicy.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace orgpolicy {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class OrgPolicyConnectionIdempotencyPolicy {
 public:
  virtual ~OrgPolicyConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<OrgPolicyConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency ListConstraints(
      google::cloud::orgpolicy::v2::ListConstraintsRequest request) = 0;

  virtual google::cloud::Idempotency ListPolicies(
      google::cloud::orgpolicy::v2::ListPoliciesRequest request) = 0;

  virtual google::cloud::Idempotency GetPolicy(
      google::cloud::orgpolicy::v2::GetPolicyRequest const& request) = 0;

  virtual google::cloud::Idempotency GetEffectivePolicy(
      google::cloud::orgpolicy::v2::GetEffectivePolicyRequest const&
          request) = 0;

  virtual google::cloud::Idempotency CreatePolicy(
      google::cloud::orgpolicy::v2::CreatePolicyRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdatePolicy(
      google::cloud::orgpolicy::v2::UpdatePolicyRequest const& request) = 0;

  virtual google::cloud::Idempotency DeletePolicy(
      google::cloud::orgpolicy::v2::DeletePolicyRequest const& request) = 0;
};

std::unique_ptr<OrgPolicyConnectionIdempotencyPolicy>
MakeDefaultOrgPolicyConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace orgpolicy
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ORGPOLICY_ORG_POLICY_CONNECTION_IDEMPOTENCY_POLICY_H
