// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

#include "google/cloud/orgpolicy/org_policy_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace orgpolicy {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

OrgPolicyConnectionIdempotencyPolicy::~OrgPolicyConnectionIdempotencyPolicy() =
    default;

namespace {
class DefaultOrgPolicyConnectionIdempotencyPolicy
    : public OrgPolicyConnectionIdempotencyPolicy {
 public:
  ~DefaultOrgPolicyConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<OrgPolicyConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultOrgPolicyConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListConstraints(
      google::cloud::orgpolicy::v2::ListConstraintsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListPolicies(
      google::cloud::orgpolicy::v2::ListPoliciesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetPolicy(
      google::cloud::orgpolicy::v2::GetPolicyRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetEffectivePolicy(
      google::cloud::orgpolicy::v2::GetEffectivePolicyRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreatePolicy(
      google::cloud::orgpolicy::v2::CreatePolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdatePolicy(
      google::cloud::orgpolicy::v2::UpdatePolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeletePolicy(
      google::cloud::orgpolicy::v2::DeletePolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<OrgPolicyConnectionIdempotencyPolicy>
MakeDefaultOrgPolicyConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultOrgPolicyConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace orgpolicy
}  // namespace cloud
}  // namespace google
