// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orgpolicy/v2/orgpolicy.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ORGPOLICY_INTERNAL_ORG_POLICY_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ORGPOLICY_INTERNAL_ORG_POLICY_CONNECTION_IMPL_H

#include "google/cloud/orgpolicy/internal/org_policy_retry_traits.h"
#include "google/cloud/orgpolicy/internal/org_policy_stub.h"
#include "google/cloud/orgpolicy/org_policy_connection.h"
#include "google/cloud/orgpolicy/org_policy_connection_idempotency_policy.h"
#include "google/cloud/orgpolicy/org_policy_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace orgpolicy_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class OrgPolicyConnectionImpl : public orgpolicy::OrgPolicyConnection {
 public:
  ~OrgPolicyConnectionImpl() override = default;

  OrgPolicyConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<orgpolicy_internal::OrgPolicyStub> stub, Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::orgpolicy::v2::Constraint> ListConstraints(
      google::cloud::orgpolicy::v2::ListConstraintsRequest request) override;

  StreamRange<google::cloud::orgpolicy::v2::Policy> ListPolicies(
      google::cloud::orgpolicy::v2::ListPoliciesRequest request) override;

  StatusOr<google::cloud::orgpolicy::v2::Policy> GetPolicy(
      google::cloud::orgpolicy::v2::GetPolicyRequest const& request) override;

  StatusOr<google::cloud::orgpolicy::v2::Policy> GetEffectivePolicy(
      google::cloud::orgpolicy::v2::GetEffectivePolicyRequest const& request)
      override;

  StatusOr<google::cloud::orgpolicy::v2::Policy> CreatePolicy(
      google::cloud::orgpolicy::v2::CreatePolicyRequest const& request)
      override;

  StatusOr<google::cloud::orgpolicy::v2::Policy> UpdatePolicy(
      google::cloud::orgpolicy::v2::UpdatePolicyRequest const& request)
      override;

  Status DeletePolicy(google::cloud::orgpolicy::v2::DeletePolicyRequest const&
                          request) override;

 private:
  std::unique_ptr<orgpolicy::OrgPolicyRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<orgpolicy::OrgPolicyRetryPolicyOption>()) {
      return options.get<orgpolicy::OrgPolicyRetryPolicyOption>()->clone();
    }
    return options_.get<orgpolicy::OrgPolicyRetryPolicyOption>()->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<orgpolicy::OrgPolicyBackoffPolicyOption>()) {
      return options.get<orgpolicy::OrgPolicyBackoffPolicyOption>()->clone();
    }
    return options_.get<orgpolicy::OrgPolicyBackoffPolicyOption>()->clone();
  }

  std::unique_ptr<orgpolicy::OrgPolicyConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<orgpolicy::OrgPolicyConnectionIdempotencyPolicyOption>()) {
      return options
          .get<orgpolicy::OrgPolicyConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<orgpolicy::OrgPolicyConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<orgpolicy_internal::OrgPolicyStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace orgpolicy_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ORGPOLICY_INTERNAL_ORG_POLICY_CONNECTION_IMPL_H
