// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/service.proto

#include "google/cloud/notebooks/notebook_connection.h"
#include "google/cloud/notebooks/internal/notebook_connection_impl.h"
#include "google/cloud/notebooks/internal/notebook_option_defaults.h"
#include "google/cloud/notebooks/internal/notebook_stub_factory.h"
#include "google/cloud/notebooks/notebook_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace notebooks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotebookServiceConnection::~NotebookServiceConnection() = default;

StreamRange<google::cloud::notebooks::v1::Instance>
NotebookServiceConnection::ListInstances(
    google::cloud::notebooks::v1::ListInstancesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::notebooks::v1::Instance>>(
      std::move(request),
      [](google::cloud::notebooks::v1::ListInstancesRequest const&) {
        return StatusOr<google::cloud::notebooks::v1::ListInstancesResponse>{};
      },
      [](google::cloud::notebooks::v1::ListInstancesResponse const&) {
        return std::vector<google::cloud::notebooks::v1::Instance>();
      });
}

StatusOr<google::cloud::notebooks::v1::Instance>
NotebookServiceConnection::GetInstance(
    google::cloud::notebooks::v1::GetInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::CreateInstance(
    google::cloud::notebooks::v1::CreateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::RegisterInstance(
    google::cloud::notebooks::v1::RegisterInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::SetInstanceAccelerator(
    google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::SetInstanceMachineType(
    google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::UpdateInstanceConfig(
    google::cloud::notebooks::v1::UpdateInstanceConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::UpdateShieldedInstanceConfig(
    google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::SetInstanceLabels(
    google::cloud::notebooks::v1::SetInstanceLabelsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceConnection::DeleteInstance(
    google::cloud::notebooks::v1::DeleteInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::StartInstance(
    google::cloud::notebooks::v1::StartInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::StopInstance(
    google::cloud::notebooks::v1::StopInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::ResetInstance(
    google::cloud::notebooks::v1::ResetInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::ReportInstanceInfo(
    google::cloud::notebooks::v1::ReportInstanceInfoRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::notebooks::v1::IsInstanceUpgradeableResponse>
NotebookServiceConnection::IsInstanceUpgradeable(
    google::cloud::notebooks::v1::IsInstanceUpgradeableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
NotebookServiceConnection::GetInstanceHealth(
    google::cloud::notebooks::v1::GetInstanceHealthRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::UpgradeInstance(
    google::cloud::notebooks::v1::UpgradeInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::RollbackInstance(
    google::cloud::notebooks::v1::RollbackInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceConnection::UpgradeInstanceInternal(
    google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::notebooks::v1::Environment>
NotebookServiceConnection::ListEnvironments(
    google::cloud::notebooks::v1::ListEnvironmentsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::notebooks::v1::Environment>>(
      std::move(request),
      [](google::cloud::notebooks::v1::ListEnvironmentsRequest const&) {
        return StatusOr<
            google::cloud::notebooks::v1::ListEnvironmentsResponse>{};
      },
      [](google::cloud::notebooks::v1::ListEnvironmentsResponse const&) {
        return std::vector<google::cloud::notebooks::v1::Environment>();
      });
}

StatusOr<google::cloud::notebooks::v1::Environment>
NotebookServiceConnection::GetEnvironment(
    google::cloud::notebooks::v1::GetEnvironmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v1::Environment>>
NotebookServiceConnection::CreateEnvironment(
    google::cloud::notebooks::v1::CreateEnvironmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Environment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceConnection::DeleteEnvironment(
    google::cloud::notebooks::v1::DeleteEnvironmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::notebooks::v1::Schedule>
NotebookServiceConnection::ListSchedules(
    google::cloud::notebooks::v1::ListSchedulesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::notebooks::v1::Schedule>>(
      std::move(request),
      [](google::cloud::notebooks::v1::ListSchedulesRequest const&) {
        return StatusOr<google::cloud::notebooks::v1::ListSchedulesResponse>{};
      },
      [](google::cloud::notebooks::v1::ListSchedulesResponse const&) {
        return std::vector<google::cloud::notebooks::v1::Schedule>();
      });
}

StatusOr<google::cloud::notebooks::v1::Schedule>
NotebookServiceConnection::GetSchedule(
    google::cloud::notebooks::v1::GetScheduleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceConnection::DeleteSchedule(
    google::cloud::notebooks::v1::DeleteScheduleRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Schedule>>
NotebookServiceConnection::CreateSchedule(
    google::cloud::notebooks::v1::CreateScheduleRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Schedule>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Schedule>>
NotebookServiceConnection::TriggerSchedule(
    google::cloud::notebooks::v1::TriggerScheduleRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Schedule>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::notebooks::v1::Execution>
NotebookServiceConnection::ListExecutions(
    google::cloud::notebooks::v1::ListExecutionsRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::notebooks::v1::Execution>>(
      std::move(request),
      [](google::cloud::notebooks::v1::ListExecutionsRequest const&) {
        return StatusOr<google::cloud::notebooks::v1::ListExecutionsResponse>{};
      },
      [](google::cloud::notebooks::v1::ListExecutionsResponse const&) {
        return std::vector<google::cloud::notebooks::v1::Execution>();
      });
}

StatusOr<google::cloud::notebooks::v1::Execution>
NotebookServiceConnection::GetExecution(
    google::cloud::notebooks::v1::GetExecutionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceConnection::DeleteExecution(
    google::cloud::notebooks::v1::DeleteExecutionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Execution>>
NotebookServiceConnection::CreateExecution(
    google::cloud::notebooks::v1::CreateExecutionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Execution>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<NotebookServiceConnection> MakeNotebookServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 NotebookServicePolicyOptionList>(options,
                                                                  __func__);
  options =
      notebooks_internal::NotebookServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = notebooks_internal::CreateDefaultNotebookServiceStub(
      background->cq(), options);
  return std::make_shared<notebooks_internal::NotebookServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace notebooks_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<notebooks::NotebookServiceConnection>
MakeNotebookServiceConnection(std::shared_ptr<NotebookServiceStub> stub,
                              Options options) {
  options = NotebookServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<notebooks_internal::NotebookServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_internal
}  // namespace cloud
}  // namespace google
