// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_NOTEBOOK_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_NOTEBOOK_CLIENT_H

#include "google/cloud/notebooks/notebook_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace notebooks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// API v1 service for Cloud AI Platform Notebooks.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class NotebookServiceClient {
 public:
  explicit NotebookServiceClient(
      std::shared_ptr<NotebookServiceConnection> connection,
      Options options = {});
  ~NotebookServiceClient();

  //@{
  // @name Copy and move support
  NotebookServiceClient(NotebookServiceClient const&) = default;
  NotebookServiceClient& operator=(NotebookServiceClient const&) = default;
  NotebookServiceClient(NotebookServiceClient&&) = default;
  NotebookServiceClient& operator=(NotebookServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(NotebookServiceClient const& a,
                         NotebookServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(NotebookServiceClient const& a,
                         NotebookServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists instances in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.ListInstancesRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L430}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  StreamRange<google::cloud::notebooks::v1::Instance> ListInstances(
      std::string const& parent, Options options = {});

  ///
  /// Lists instances in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::ListInstancesRequest,google/cloud/notebooks/v1/service.proto#L430}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.ListInstancesRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L430}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  StreamRange<google::cloud::notebooks::v1::Instance> ListInstances(
      google::cloud::notebooks::v1::ListInstancesRequest request,
      Options options = {});

  ///
  /// Gets details of a single Instance.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/instances/{instance_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.GetInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L459}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  StatusOr<google::cloud::notebooks::v1::Instance> GetInstance(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single Instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::GetInstanceRequest,google/cloud/notebooks/v1/service.proto#L459}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.GetInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L459}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  StatusOr<google::cloud::notebooks::v1::Instance> GetInstance(
      google::cloud::notebooks::v1::GetInstanceRequest const& request,
      Options options = {});

  ///
  /// Creates a new Instance in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param instance  Required. The instance to be created.
  /// @param instance_id  Required. User-defined unique ID of this instance.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.CreateInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L466}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> CreateInstance(
      std::string const& parent,
      google::cloud::notebooks::v1::Instance const& instance,
      std::string const& instance_id, Options options = {});

  ///
  /// Creates a new Instance in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::CreateInstanceRequest,google/cloud/notebooks/v1/service.proto#L466}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.CreateInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L466}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> CreateInstance(
      google::cloud::notebooks::v1::CreateInstanceRequest const& request,
      Options options = {});

  ///
  /// Registers an existing legacy notebook instance to the Notebooks API
  /// server. Legacy instances are instances created with the legacy Compute
  /// Engine calls. They are not manageable by the Notebooks API out of the box.
  /// This call makes these instances manageable by the Notebooks API.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::RegisterInstanceRequest,google/cloud/notebooks/v1/service.proto#L479}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.RegisterInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L479}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> RegisterInstance(
      google::cloud::notebooks::v1::RegisterInstanceRequest const& request,
      Options options = {});

  ///
  /// Updates the guest accelerators of a single Instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::SetInstanceAcceleratorRequest,google/cloud/notebooks/v1/service.proto#L492}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.SetInstanceAcceleratorRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L492}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceAccelerator(
      google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const&
          request,
      Options options = {});

  ///
  /// Updates the machine type of a single Instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::SetInstanceMachineTypeRequest,google/cloud/notebooks/v1/service.proto#L508}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.SetInstanceMachineTypeRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L508}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceMachineType(
      google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const&
          request,
      Options options = {});

  ///
  /// Update Notebook Instance configurations.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::UpdateInstanceConfigRequest,google/cloud/notebooks/v1/service.proto#L519}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.UpdateInstanceConfigRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L519}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> UpdateInstanceConfig(
      google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request,
      Options options = {});

  ///
  /// Updates the Shielded instance configuration of a single Instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest,google/cloud/notebooks/v1/service.proto#L541}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.UpdateShieldedInstanceConfigRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L541}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpdateShieldedInstanceConfig(
      google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
          request,
      Options options = {});

  ///
  /// Replaces all the labels of an Instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::SetInstanceLabelsRequest,google/cloud/notebooks/v1/service.proto#L529}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.SetInstanceLabelsRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L529}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> SetInstanceLabels(
      google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request,
      Options options = {});

  ///
  /// Deletes a single Instance.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/instances/{instance_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L551}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteInstance(std::string const& name, Options options = {});

  ///
  /// Deletes a single Instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::DeleteInstanceRequest,google/cloud/notebooks/v1/service.proto#L551}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L551}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::notebooks::v1::DeleteInstanceRequest const& request,
      Options options = {});

  ///
  /// Starts a notebook instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::StartInstanceRequest,google/cloud/notebooks/v1/service.proto#L558}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.StartInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L558}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> StartInstance(
      google::cloud::notebooks::v1::StartInstanceRequest const& request,
      Options options = {});

  ///
  /// Stops a notebook instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::StopInstanceRequest,google/cloud/notebooks/v1/service.proto#L565}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.StopInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L565}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> StopInstance(
      google::cloud::notebooks::v1::StopInstanceRequest const& request,
      Options options = {});

  ///
  /// Resets a notebook instance.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::ResetInstanceRequest,google/cloud/notebooks/v1/service.proto#L572}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.ResetInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L572}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> ResetInstance(
      google::cloud::notebooks::v1::ResetInstanceRequest const& request,
      Options options = {});

  ///
  /// Allows notebook instances to
  /// report their latest instance information to the Notebooks
  /// API server. The server will merge the reported information to
  /// the instance metadata store. Do not use this method directly.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::ReportInstanceInfoRequest,google/cloud/notebooks/v1/service.proto#L579}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.ReportInstanceInfoRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L579}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> ReportInstanceInfo(
      google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request,
      Options options = {});

  ///
  /// Check if a notebook instance is upgradable.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::IsInstanceUpgradeableRequest,google/cloud/notebooks/v1/service.proto#L594}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::IsInstanceUpgradeableResponse,google/cloud/notebooks/v1/service.proto#L601}
  ///
  /// [google.cloud.notebooks.v1.IsInstanceUpgradeableRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L594}
  /// [google.cloud.notebooks.v1.IsInstanceUpgradeableResponse]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L601}
  ///
  StatusOr<google::cloud::notebooks::v1::IsInstanceUpgradeableResponse>
  IsInstanceUpgradeable(
      google::cloud::notebooks::v1::IsInstanceUpgradeableRequest const& request,
      Options options = {});

  ///
  /// Check if a notebook instance is healthy.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/instances/{instance_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::GetInstanceHealthResponse,google/cloud/notebooks/v1/service.proto#L631}
  ///
  /// [google.cloud.notebooks.v1.GetInstanceHealthRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L619}
  /// [google.cloud.notebooks.v1.GetInstanceHealthResponse]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L631}
  ///
  StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
  GetInstanceHealth(std::string const& name, Options options = {});

  ///
  /// Check if a notebook instance is healthy.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::GetInstanceHealthRequest,google/cloud/notebooks/v1/service.proto#L619}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::GetInstanceHealthResponse,google/cloud/notebooks/v1/service.proto#L631}
  ///
  /// [google.cloud.notebooks.v1.GetInstanceHealthRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L619}
  /// [google.cloud.notebooks.v1.GetInstanceHealthResponse]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L631}
  ///
  StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
  GetInstanceHealth(
      google::cloud::notebooks::v1::GetInstanceHealthRequest const& request,
      Options options = {});

  ///
  /// Upgrades a notebook instance to the latest version.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::UpgradeInstanceRequest,google/cloud/notebooks/v1/service.proto#L672}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.UpgradeInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L672}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> UpgradeInstance(
      google::cloud::notebooks::v1::UpgradeInstanceRequest const& request,
      Options options = {});

  ///
  /// Rollbacks a notebook instance to the previous version.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::RollbackInstanceRequest,google/cloud/notebooks/v1/service.proto#L679}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.RollbackInstanceRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L679}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>> RollbackInstance(
      google::cloud::notebooks::v1::RollbackInstanceRequest const& request,
      Options options = {});

  ///
  /// Allows notebook instances to
  /// call this endpoint to upgrade themselves. Do not use this method directly.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::UpgradeInstanceInternalRequest,google/cloud/notebooks/v1/service.proto#L690}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Instance,google/cloud/notebooks/v1/instance.proto#L61}
  ///
  /// [google.cloud.notebooks.v1.UpgradeInstanceInternalRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L690}
  /// [google.cloud.notebooks.v1.Instance]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpgradeInstanceInternal(
      google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const&
          request,
      Options options = {});

  ///
  /// Lists environments in a project.
  ///
  /// @param parent  Required. Format:
  /// `projects/{project_id}/locations/{location}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Environment,google/cloud/notebooks/v1/environment.proto#L33}
  ///
  /// [google.cloud.notebooks.v1.ListEnvironmentsRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L701}
  /// [google.cloud.notebooks.v1.Environment]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  StreamRange<google::cloud::notebooks::v1::Environment> ListEnvironments(
      std::string const& parent, Options options = {});

  ///
  /// Lists environments in a project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::ListEnvironmentsRequest,google/cloud/notebooks/v1/service.proto#L701}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Environment,google/cloud/notebooks/v1/environment.proto#L33}
  ///
  /// [google.cloud.notebooks.v1.ListEnvironmentsRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L701}
  /// [google.cloud.notebooks.v1.Environment]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  StreamRange<google::cloud::notebooks::v1::Environment> ListEnvironments(
      google::cloud::notebooks::v1::ListEnvironmentsRequest request,
      Options options = {});

  ///
  /// Gets details of a single Environment.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/environments/{environment_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Environment,google/cloud/notebooks/v1/environment.proto#L33}
  ///
  /// [google.cloud.notebooks.v1.GetEnvironmentRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L727}
  /// [google.cloud.notebooks.v1.Environment]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  StatusOr<google::cloud::notebooks::v1::Environment> GetEnvironment(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single Environment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::GetEnvironmentRequest,google/cloud/notebooks/v1/service.proto#L727}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Environment,google/cloud/notebooks/v1/environment.proto#L33}
  ///
  /// [google.cloud.notebooks.v1.GetEnvironmentRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L727}
  /// [google.cloud.notebooks.v1.Environment]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  StatusOr<google::cloud::notebooks::v1::Environment> GetEnvironment(
      google::cloud::notebooks::v1::GetEnvironmentRequest const& request,
      Options options = {});

  ///
  /// Creates a new Environment.
  ///
  /// @param parent  Required. Format:
  /// `projects/{project_id}/locations/{location}`
  /// @param environment  Required. The environment to be created.
  /// @param environment_id  Required. User-defined unique ID of this
  /// environment. The `environment_id` must
  ///  be 1 to 63 characters long and contain only lowercase letters,
  ///  numeric characters, and dashes. The first character must be a lowercase
  ///  letter and the last character cannot be a dash.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Environment,google/cloud/notebooks/v1/environment.proto#L33}
  ///
  /// [google.cloud.notebooks.v1.CreateEnvironmentRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L734}
  /// [google.cloud.notebooks.v1.Environment]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Environment>> CreateEnvironment(
      std::string const& parent,
      google::cloud::notebooks::v1::Environment const& environment,
      std::string const& environment_id, Options options = {});

  ///
  /// Creates a new Environment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::CreateEnvironmentRequest,google/cloud/notebooks/v1/service.proto#L734}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Environment,google/cloud/notebooks/v1/environment.proto#L33}
  ///
  /// [google.cloud.notebooks.v1.CreateEnvironmentRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L734}
  /// [google.cloud.notebooks.v1.Environment]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Environment>> CreateEnvironment(
      google::cloud::notebooks::v1::CreateEnvironmentRequest const& request,
      Options options = {});

  ///
  /// Deletes a single Environment.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/environments/{environment_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteEnvironmentRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L749}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteEnvironment(std::string const& name, Options options = {});

  ///
  /// Deletes a single Environment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::DeleteEnvironmentRequest,google/cloud/notebooks/v1/service.proto#L749}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteEnvironmentRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L749}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteEnvironment(
      google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request,
      Options options = {});

  ///
  /// Lists schedules in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Schedule,google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  /// [google.cloud.notebooks.v1.ListSchedulesRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L756}
  /// [google.cloud.notebooks.v1.Schedule]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  StreamRange<google::cloud::notebooks::v1::Schedule> ListSchedules(
      std::string const& parent, Options options = {});

  ///
  /// Lists schedules in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::ListSchedulesRequest,google/cloud/notebooks/v1/service.proto#L756}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Schedule,google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  /// [google.cloud.notebooks.v1.ListSchedulesRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L756}
  /// [google.cloud.notebooks.v1.Schedule]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  StreamRange<google::cloud::notebooks::v1::Schedule> ListSchedules(
      google::cloud::notebooks::v1::ListSchedulesRequest request,
      Options options = {});

  ///
  /// Gets details of schedule
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Schedule,google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  /// [google.cloud.notebooks.v1.GetScheduleRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L797}
  /// [google.cloud.notebooks.v1.Schedule]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  StatusOr<google::cloud::notebooks::v1::Schedule> GetSchedule(
      std::string const& name, Options options = {});

  ///
  /// Gets details of schedule
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::GetScheduleRequest,google/cloud/notebooks/v1/service.proto#L797}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Schedule,google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  /// [google.cloud.notebooks.v1.GetScheduleRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L797}
  /// [google.cloud.notebooks.v1.Schedule]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  StatusOr<google::cloud::notebooks::v1::Schedule> GetSchedule(
      google::cloud::notebooks::v1::GetScheduleRequest const& request,
      Options options = {});

  ///
  /// Deletes schedule and all underlying jobs
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteScheduleRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L809}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteSchedule(std::string const& name, Options options = {});

  ///
  /// Deletes schedule and all underlying jobs
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::DeleteScheduleRequest,google/cloud/notebooks/v1/service.proto#L809}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteScheduleRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L809}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteSchedule(
      google::cloud::notebooks::v1::DeleteScheduleRequest const& request,
      Options options = {});

  ///
  /// Creates a new Scheduled Notebook in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param schedule  Required. The schedule to be created.
  /// @param schedule_id  Required. User-defined unique ID of this schedule.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Schedule,google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  /// [google.cloud.notebooks.v1.CreateScheduleRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L821}
  /// [google.cloud.notebooks.v1.Schedule]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Schedule>> CreateSchedule(
      std::string const& parent,
      google::cloud::notebooks::v1::Schedule const& schedule,
      std::string const& schedule_id, Options options = {});

  ///
  /// Creates a new Scheduled Notebook in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::CreateScheduleRequest,google/cloud/notebooks/v1/service.proto#L821}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Schedule,google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  /// [google.cloud.notebooks.v1.CreateScheduleRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L821}
  /// [google.cloud.notebooks.v1.Schedule]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Schedule>> CreateSchedule(
      google::cloud::notebooks::v1::CreateScheduleRequest const& request,
      Options options = {});

  ///
  /// Triggers execution of an existing schedule.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::TriggerScheduleRequest,google/cloud/notebooks/v1/service.proto#L839}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Schedule,google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  /// [google.cloud.notebooks.v1.TriggerScheduleRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L839}
  /// [google.cloud.notebooks.v1.Schedule]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Schedule>> TriggerSchedule(
      google::cloud::notebooks::v1::TriggerScheduleRequest const& request,
      Options options = {});

  ///
  /// Lists executions in a given project and location
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Execution,google/cloud/notebooks/v1/execution.proto#L250}
  ///
  /// [google.cloud.notebooks.v1.ListExecutionsRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L851}
  /// [google.cloud.notebooks.v1.Execution]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L250}
  ///
  StreamRange<google::cloud::notebooks::v1::Execution> ListExecutions(
      std::string const& parent, Options options = {});

  ///
  /// Lists executions in a given project and location
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::ListExecutionsRequest,google/cloud/notebooks/v1/service.proto#L851}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Execution,google/cloud/notebooks/v1/execution.proto#L250}
  ///
  /// [google.cloud.notebooks.v1.ListExecutionsRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L851}
  /// [google.cloud.notebooks.v1.Execution]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L250}
  ///
  StreamRange<google::cloud::notebooks::v1::Execution> ListExecutions(
      google::cloud::notebooks::v1::ListExecutionsRequest request,
      Options options = {});

  ///
  /// Gets details of executions
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/executions/{execution_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Execution,google/cloud/notebooks/v1/execution.proto#L250}
  ///
  /// [google.cloud.notebooks.v1.GetExecutionRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L894}
  /// [google.cloud.notebooks.v1.Execution]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L250}
  ///
  StatusOr<google::cloud::notebooks::v1::Execution> GetExecution(
      std::string const& name, Options options = {});

  ///
  /// Gets details of executions
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::GetExecutionRequest,google/cloud/notebooks/v1/service.proto#L894}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Execution,google/cloud/notebooks/v1/execution.proto#L250}
  ///
  /// [google.cloud.notebooks.v1.GetExecutionRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L894}
  /// [google.cloud.notebooks.v1.Execution]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L250}
  ///
  StatusOr<google::cloud::notebooks::v1::Execution> GetExecution(
      google::cloud::notebooks::v1::GetExecutionRequest const& request,
      Options options = {});

  ///
  /// Deletes execution
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/executions/{execution_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteExecutionRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L906}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteExecution(std::string const& name, Options options = {});

  ///
  /// Deletes execution
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::DeleteExecutionRequest,google/cloud/notebooks/v1/service.proto#L906}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::OperationMetadata,google/cloud/notebooks/v1/service.proto#L400}
  ///
  /// [google.cloud.notebooks.v1.DeleteExecutionRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L906}
  /// [google.cloud.notebooks.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L400}
  ///
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteExecution(
      google::cloud::notebooks::v1::DeleteExecutionRequest const& request,
      Options options = {});

  ///
  /// Creates a new Scheduled Notebook in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param execution  Required. The execution to be created.
  /// @param execution_id  Required. User-defined unique ID of this execution.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Execution,google/cloud/notebooks/v1/execution.proto#L250}
  ///
  /// [google.cloud.notebooks.v1.CreateExecutionRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L918}
  /// [google.cloud.notebooks.v1.Execution]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L250}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Execution>> CreateExecution(
      std::string const& parent,
      google::cloud::notebooks::v1::Execution const& execution,
      std::string const& execution_id, Options options = {});

  ///
  /// Creates a new Scheduled Notebook in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::notebooks::v1::CreateExecutionRequest,google/cloud/notebooks/v1/service.proto#L918}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::notebooks::v1::Execution,google/cloud/notebooks/v1/execution.proto#L250}
  ///
  /// [google.cloud.notebooks.v1.CreateExecutionRequest]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L918}
  /// [google.cloud.notebooks.v1.Execution]:
  /// @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L250}
  ///
  future<StatusOr<google::cloud::notebooks::v1::Execution>> CreateExecution(
      google::cloud::notebooks::v1::CreateExecutionRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<NotebookServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_NOTEBOOK_CLIENT_H
