// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#include "google/cloud/notebooks/managed_notebook_connection.h"
#include "google/cloud/notebooks/internal/managed_notebook_connection_impl.h"
#include "google/cloud/notebooks/internal/managed_notebook_option_defaults.h"
#include "google/cloud/notebooks/internal/managed_notebook_stub_factory.h"
#include "google/cloud/notebooks/managed_notebook_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace notebooks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ManagedNotebookServiceConnection::~ManagedNotebookServiceConnection() = default;

StreamRange<google::cloud::notebooks::v1::Runtime>
ManagedNotebookServiceConnection::ListRuntimes(
    google::cloud::notebooks::v1::ListRuntimesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::notebooks::v1::Runtime>>(
      std::move(request),
      [](google::cloud::notebooks::v1::ListRuntimesRequest const&) {
        return StatusOr<google::cloud::notebooks::v1::ListRuntimesResponse>{};
      },
      [](google::cloud::notebooks::v1::ListRuntimesResponse const&) {
        return std::vector<google::cloud::notebooks::v1::Runtime>();
      });
}

StatusOr<google::cloud::notebooks::v1::Runtime>
ManagedNotebookServiceConnection::GetRuntime(
    google::cloud::notebooks::v1::GetRuntimeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceConnection::CreateRuntime(
    google::cloud::notebooks::v1::CreateRuntimeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Runtime>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
ManagedNotebookServiceConnection::DeleteRuntime(
    google::cloud::notebooks::v1::DeleteRuntimeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceConnection::StartRuntime(
    google::cloud::notebooks::v1::StartRuntimeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Runtime>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceConnection::StopRuntime(
    google::cloud::notebooks::v1::StopRuntimeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Runtime>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceConnection::SwitchRuntime(
    google::cloud::notebooks::v1::SwitchRuntimeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Runtime>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceConnection::ResetRuntime(
    google::cloud::notebooks::v1::ResetRuntimeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Runtime>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::notebooks::v1::Runtime>>
ManagedNotebookServiceConnection::ReportRuntimeEvent(
    google::cloud::notebooks::v1::ReportRuntimeEventRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::notebooks::v1::Runtime>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<ManagedNotebookServiceConnection>
MakeManagedNotebookServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 ManagedNotebookServicePolicyOptionList>(
      options, __func__);
  options = notebooks_internal::ManagedNotebookServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = notebooks_internal::CreateDefaultManagedNotebookServiceStub(
      background->cq(), options);
  return std::make_shared<
      notebooks_internal::ManagedNotebookServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace notebooks_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<notebooks::ManagedNotebookServiceConnection>
MakeManagedNotebookServiceConnection(
    std::shared_ptr<ManagedNotebookServiceStub> stub, Options options) {
  options = ManagedNotebookServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      notebooks_internal::ManagedNotebookServiceConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_internal
}  // namespace cloud
}  // namespace google
