// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_INTERNAL_MANAGED_NOTEBOOK_LOGGING_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_INTERNAL_MANAGED_NOTEBOOK_LOGGING_DECORATOR_H

#include "google/cloud/notebooks/internal/managed_notebook_stub.h"
#include "google/cloud/tracing_options.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace notebooks_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ManagedNotebookServiceLogging : public ManagedNotebookServiceStub {
 public:
  ~ManagedNotebookServiceLogging() override = default;
  ManagedNotebookServiceLogging(
      std::shared_ptr<ManagedNotebookServiceStub> child,
      TracingOptions tracing_options, std::set<std::string> components);

  StatusOr<google::cloud::notebooks::v1::ListRuntimesResponse> ListRuntimes(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::ListRuntimesRequest const& request)
      override;

  StatusOr<google::cloud::notebooks::v1::Runtime> GetRuntime(
      grpc::ClientContext& context,
      google::cloud::notebooks::v1::GetRuntimeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateRuntime(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::notebooks::v1::CreateRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteRuntime(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::notebooks::v1::DeleteRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncStartRuntime(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::notebooks::v1::StartRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncStopRuntime(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::notebooks::v1::StopRuntimeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncSwitchRuntime(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::notebooks::v1::SwitchRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncResetRuntime(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::notebooks::v1::ResetRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncReportRuntimeEvent(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::unique_ptr<grpc::ClientContext> context,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<ManagedNotebookServiceStub> child_;
  TracingOptions tracing_options_;
  std::set<std::string> components_;
};  // ManagedNotebookServiceLogging

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_INTERNAL_MANAGED_NOTEBOOK_LOGGING_DECORATOR_H
