// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#include "google/cloud/networkmanagement/reachability_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkmanagement {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ReachabilityServiceConnectionIdempotencyPolicy::
    ~ReachabilityServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultReachabilityServiceConnectionIdempotencyPolicy
    : public ReachabilityServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultReachabilityServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ReachabilityServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultReachabilityServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListConnectivityTests(
      google::cloud::networkmanagement::v1::ListConnectivityTestsRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetConnectivityTest(
      google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateConnectivityTest(
      google::cloud::networkmanagement::v1::
          CreateConnectivityTestRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateConnectivityTest(
      google::cloud::networkmanagement::v1::
          UpdateConnectivityTestRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency RerunConnectivityTest(
      google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteConnectivityTest(
      google::cloud::networkmanagement::v1::
          DeleteConnectivityTestRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ReachabilityServiceConnectionIdempotencyPolicy>
MakeDefaultReachabilityServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultReachabilityServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement
}  // namespace cloud
}  // namespace google
