// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#include "google/cloud/networkmanagement/internal/reachability_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/networkmanagement/v1/reachability.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networkmanagement_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ReachabilityServiceMetadata::ReachabilityServiceMetadata(
    std::shared_ptr<ReachabilityServiceStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::networkmanagement::v1::ListConnectivityTestsResponse>
ReachabilityServiceMetadata::ListConnectivityTests(
    grpc::ClientContext& context,
    google::cloud::networkmanagement::v1::ListConnectivityTestsRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListConnectivityTests(context, request);
}

StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>
ReachabilityServiceMetadata::GetConnectivityTest(
    grpc::ClientContext& context,
    google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetConnectivityTest(context, request);
}

future<StatusOr<google::longrunning::Operation>>
ReachabilityServiceMetadata::AsyncCreateConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
        request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateConnectivityTest(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ReachabilityServiceMetadata::AsyncUpdateConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
        request) {
  SetMetadata(*context, "resource.name=" + request.resource().name());
  return child_->AsyncUpdateConnectivityTest(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ReachabilityServiceMetadata::AsyncRerunConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
        request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncRerunConnectivityTest(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ReachabilityServiceMetadata::AsyncDeleteConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
        request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteConnectivityTest(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
ReachabilityServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> ReachabilityServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void ReachabilityServiceMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void ReachabilityServiceMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_internal
}  // namespace cloud
}  // namespace google
