// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_INTERNAL_REACHABILITY_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_INTERNAL_REACHABILITY_CONNECTION_IMPL_H

#include "google/cloud/networkmanagement/internal/reachability_retry_traits.h"
#include "google/cloud/networkmanagement/internal/reachability_stub.h"
#include "google/cloud/networkmanagement/reachability_connection.h"
#include "google/cloud/networkmanagement/reachability_connection_idempotency_policy.h"
#include "google/cloud/networkmanagement/reachability_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networkmanagement_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ReachabilityServiceConnectionImpl
    : public networkmanagement::ReachabilityServiceConnection {
 public:
  ~ReachabilityServiceConnectionImpl() override = default;

  ReachabilityServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<networkmanagement_internal::ReachabilityServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::networkmanagement::v1::ConnectivityTest>
  ListConnectivityTests(
      google::cloud::networkmanagement::v1::ListConnectivityTestsRequest
          request) override;

  StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>
  GetConnectivityTest(
      google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  CreateConnectivityTest(
      google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  UpdateConnectivityTest(
      google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
  RerunConnectivityTest(
      google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
          request) override;

  future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
  DeleteConnectivityTest(
      google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
          request) override;

 private:
  std::unique_ptr<networkmanagement::ReachabilityServiceRetryPolicy>
  retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<networkmanagement::ReachabilityServiceRetryPolicyOption>()) {
      return options
          .get<networkmanagement::ReachabilityServiceRetryPolicyOption>()
          ->clone();
    }
    return options_
        .get<networkmanagement::ReachabilityServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<networkmanagement::ReachabilityServiceBackoffPolicyOption>()) {
      return options
          .get<networkmanagement::ReachabilityServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_
        .get<networkmanagement::ReachabilityServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<
      networkmanagement::ReachabilityServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<networkmanagement::
                     ReachabilityServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<networkmanagement::
                   ReachabilityServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<networkmanagement::
                 ReachabilityServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<PollingPolicy> polling_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<networkmanagement::ReachabilityServicePollingPolicyOption>()) {
      return options
          .get<networkmanagement::ReachabilityServicePollingPolicyOption>()
          ->clone();
    }
    return options_
        .get<networkmanagement::ReachabilityServicePollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<networkmanagement_internal::ReachabilityServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_INTERNAL_REACHABILITY_CONNECTION_IMPL_H
