// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#include "google/cloud/monitoring/service_monitoring_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ServiceMonitoringServiceConnectionIdempotencyPolicy::
    ~ServiceMonitoringServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultServiceMonitoringServiceConnectionIdempotencyPolicy
    : public ServiceMonitoringServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultServiceMonitoringServiceConnectionIdempotencyPolicy() override =
      default;

  /// Create a new copy of this object.
  std::unique_ptr<ServiceMonitoringServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultServiceMonitoringServiceConnectionIdempotencyPolicy>(*this);
  }

  Idempotency CreateService(
      google::monitoring::v3::CreateServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetService(
      google::monitoring::v3::GetServiceRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListServices(
      google::monitoring::v3::ListServicesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateService(
      google::monitoring::v3::UpdateServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteService(
      google::monitoring::v3::DeleteServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateServiceLevelObjective(
      google::monitoring::v3::CreateServiceLevelObjectiveRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetServiceLevelObjective(
      google::monitoring::v3::GetServiceLevelObjectiveRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListServiceLevelObjectives(
      google::monitoring::v3::ListServiceLevelObjectivesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateServiceLevelObjective(
      google::monitoring::v3::UpdateServiceLevelObjectiveRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteServiceLevelObjective(
      google::monitoring::v3::DeleteServiceLevelObjectiveRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ServiceMonitoringServiceConnectionIdempotencyPolicy>
MakeDefaultServiceMonitoringServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultServiceMonitoringServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google
