// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_SERVICE_MONITORING_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_SERVICE_MONITORING_CLIENT_H

#include "google/cloud/monitoring/service_monitoring_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Cloud Monitoring Service-Oriented Monitoring API has endpoints for
/// managing and querying aspects of a workspace's services. These include the
/// `Service`'s monitored resources, its Service-Level Objectives, and a
/// taxonomy of categorized Health Metrics.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ServiceMonitoringServiceClient {
 public:
  explicit ServiceMonitoringServiceClient(
      std::shared_ptr<ServiceMonitoringServiceConnection> connection,
      Options options = {});
  ~ServiceMonitoringServiceClient();

  //@{
  // @name Copy and move support
  ServiceMonitoringServiceClient(ServiceMonitoringServiceClient const&) =
      default;
  ServiceMonitoringServiceClient& operator=(
      ServiceMonitoringServiceClient const&) = default;
  ServiceMonitoringServiceClient(ServiceMonitoringServiceClient&&) = default;
  ServiceMonitoringServiceClient& operator=(ServiceMonitoringServiceClient&&) =
      default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ServiceMonitoringServiceClient const& a,
                         ServiceMonitoringServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ServiceMonitoringServiceClient const& a,
                         ServiceMonitoringServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Create a `Service`.
  ///
  /// @param parent  Required. Resource
  /// [name](https://cloud.google.com/monitoring/api/v3#project_name) of
  ///  the parent workspace. The format is:
  ///      projects/[PROJECT_ID_OR_NUMBER]
  /// @param service  Required. The `Service` to create.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.CreateServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L132}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StatusOr<google::monitoring::v3::Service> CreateService(
      std::string const& parent, google::monitoring::v3::Service const& service,
      Options options = {});

  ///
  /// Create a `Service`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::CreateServiceRequest,google/monitoring/v3/service_service.proto#L132}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.CreateServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L132}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StatusOr<google::monitoring::v3::Service> CreateService(
      google::monitoring::v3::CreateServiceRequest const& request,
      Options options = {});

  ///
  /// Get the named `Service`.
  ///
  /// @param name  Required. Resource name of the `Service`. The format is:
  ///      projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.GetServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L153}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StatusOr<google::monitoring::v3::Service> GetService(std::string const& name,
                                                       Options options = {});

  ///
  /// Get the named `Service`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::GetServiceRequest,google/monitoring/v3/service_service.proto#L153}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.GetServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L153}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StatusOr<google::monitoring::v3::Service> GetService(
      google::monitoring::v3::GetServiceRequest const& request,
      Options options = {});

  ///
  /// List `Service`s for this workspace.
  ///
  /// @param parent  Required. Resource name of the parent containing the listed
  /// services, either a
  ///  [project](https://cloud.google.com/monitoring/api/v3#project_name) or a
  ///  Monitoring Workspace. The formats are:
  ///      projects/[PROJECT_ID_OR_NUMBER]
  ///      workspaces/[HOST_PROJECT_ID_OR_NUMBER]
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.ListServicesRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L166}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StreamRange<google::monitoring::v3::Service> ListServices(
      std::string const& parent, Options options = {});

  ///
  /// List `Service`s for this workspace.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::ListServicesRequest,google/monitoring/v3/service_service.proto#L166}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.ListServicesRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L166}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StreamRange<google::monitoring::v3::Service> ListServices(
      google::monitoring::v3::ListServicesRequest request,
      Options options = {});

  ///
  /// Update this `Service`.
  ///
  /// @param service  Required. The `Service` to draw updates from.
  ///  The given `name` specifies the resource to update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.UpdateServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L223}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StatusOr<google::monitoring::v3::Service> UpdateService(
      google::monitoring::v3::Service const& service, Options options = {});

  ///
  /// Update this `Service`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::UpdateServiceRequest,google/monitoring/v3/service_service.proto#L223}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::Service,google/monitoring/v3/service.proto#L38}
  ///
  /// [google.monitoring.v3.UpdateServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L223}
  /// [google.monitoring.v3.Service]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L38}
  ///
  StatusOr<google::monitoring::v3::Service> UpdateService(
      google::monitoring::v3::UpdateServiceRequest const& request,
      Options options = {});

  ///
  /// Soft delete this `Service`.
  ///
  /// @param name  Required. Resource name of the `Service` to delete. The
  /// format is:
  ///      projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
  /// @param options  Optional. Operation options.
  ///
  /// [google.monitoring.v3.DeleteServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L233}
  ///
  Status DeleteService(std::string const& name, Options options = {});

  ///
  /// Soft delete this `Service`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::DeleteServiceRequest,google/monitoring/v3/service_service.proto#L233}
  /// @param options  Optional. Operation options.
  ///
  /// [google.monitoring.v3.DeleteServiceRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L233}
  ///
  Status DeleteService(
      google::monitoring::v3::DeleteServiceRequest const& request,
      Options options = {});

  ///
  /// Create a `ServiceLevelObjective` for the given `Service`.
  ///
  /// @param parent  Required. Resource name of the parent `Service`. The format
  /// is:
  ///      projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
  /// @param service_level_objective  Required. The `ServiceLevelObjective` to
  /// create.
  ///  The provided `name` will be respected if no `ServiceLevelObjective`
  ///  exists with this name.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.CreateServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L246}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StatusOr<google::monitoring::v3::ServiceLevelObjective>
  CreateServiceLevelObjective(
      std::string const& parent,
      google::monitoring::v3::ServiceLevelObjective const&
          service_level_objective,
      Options options = {});

  ///
  /// Create a `ServiceLevelObjective` for the given `Service`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::CreateServiceLevelObjectiveRequest,google/monitoring/v3/service_service.proto#L246}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.CreateServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L246}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StatusOr<google::monitoring::v3::ServiceLevelObjective>
  CreateServiceLevelObjective(
      google::monitoring::v3::CreateServiceLevelObjectiveRequest const& request,
      Options options = {});

  ///
  /// Get a `ServiceLevelObjective` by name.
  ///
  /// @param name  Required. Resource name of the `ServiceLevelObjective` to
  /// get. The format is:
  ///      projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.GetServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L269}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StatusOr<google::monitoring::v3::ServiceLevelObjective>
  GetServiceLevelObjective(std::string const& name, Options options = {});

  ///
  /// Get a `ServiceLevelObjective` by name.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::GetServiceLevelObjectiveRequest,google/monitoring/v3/service_service.proto#L269}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.GetServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L269}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StatusOr<google::monitoring::v3::ServiceLevelObjective>
  GetServiceLevelObjective(
      google::monitoring::v3::GetServiceLevelObjectiveRequest const& request,
      Options options = {});

  ///
  /// List the `ServiceLevelObjective`s for the given `Service`.
  ///
  /// @param parent  Required. Resource name of the parent containing the listed
  /// SLOs, either a
  ///  project or a Monitoring Workspace. The formats are:
  ///      projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
  ///      workspaces/[HOST_PROJECT_ID_OR_NUMBER]/services/-
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.ListServiceLevelObjectivesRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L288}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StreamRange<google::monitoring::v3::ServiceLevelObjective>
  ListServiceLevelObjectives(std::string const& parent, Options options = {});

  ///
  /// List the `ServiceLevelObjective`s for the given `Service`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::ListServiceLevelObjectivesRequest,google/monitoring/v3/service_service.proto#L288}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.ListServiceLevelObjectivesRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L288}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StreamRange<google::monitoring::v3::ServiceLevelObjective>
  ListServiceLevelObjectives(
      google::monitoring::v3::ListServiceLevelObjectivesRequest request,
      Options options = {});

  ///
  /// Update the given `ServiceLevelObjective`.
  ///
  /// @param service_level_objective  Required. The `ServiceLevelObjective` to
  /// draw updates from.
  ///  The given `name` specifies the resource to update.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.UpdateServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L332}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StatusOr<google::monitoring::v3::ServiceLevelObjective>
  UpdateServiceLevelObjective(
      google::monitoring::v3::ServiceLevelObjective const&
          service_level_objective,
      Options options = {});

  ///
  /// Update the given `ServiceLevelObjective`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::UpdateServiceLevelObjectiveRequest,google/monitoring/v3/service_service.proto#L332}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::monitoring::v3::ServiceLevelObjective,google/monitoring/v3/service.proto#L185}
  ///
  /// [google.monitoring.v3.UpdateServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L332}
  /// [google.monitoring.v3.ServiceLevelObjective]:
  /// @googleapis_reference_link{google/monitoring/v3/service.proto#L185}
  ///
  StatusOr<google::monitoring::v3::ServiceLevelObjective>
  UpdateServiceLevelObjective(
      google::monitoring::v3::UpdateServiceLevelObjectiveRequest const& request,
      Options options = {});

  ///
  /// Delete the given `ServiceLevelObjective`.
  ///
  /// @param name  Required. Resource name of the `ServiceLevelObjective` to
  /// delete. The format is:
  ///      projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
  /// @param options  Optional. Operation options.
  ///
  /// [google.monitoring.v3.DeleteServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L342}
  ///
  Status DeleteServiceLevelObjective(std::string const& name,
                                     Options options = {});

  ///
  /// Delete the given `ServiceLevelObjective`.
  ///
  /// @param request
  /// @googleapis_link{google::monitoring::v3::DeleteServiceLevelObjectiveRequest,google/monitoring/v3/service_service.proto#L342}
  /// @param options  Optional. Operation options.
  ///
  /// [google.monitoring.v3.DeleteServiceLevelObjectiveRequest]:
  /// @googleapis_reference_link{google/monitoring/v3/service_service.proto#L342}
  ///
  Status DeleteServiceLevelObjective(
      google::monitoring::v3::DeleteServiceLevelObjectiveRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<ServiceMonitoringServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_SERVICE_MONITORING_CLIENT_H
