// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/metricsscope/v1/metrics_scopes.proto

#include "google/cloud/monitoring/metrics_scopes_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

MetricsScopesConnectionIdempotencyPolicy::
    ~MetricsScopesConnectionIdempotencyPolicy() = default;

namespace {
class DefaultMetricsScopesConnectionIdempotencyPolicy
    : public MetricsScopesConnectionIdempotencyPolicy {
 public:
  ~DefaultMetricsScopesConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<MetricsScopesConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultMetricsScopesConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency GetMetricsScope(
      google::monitoring::metricsscope::v1::GetMetricsScopeRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListMetricsScopesByMonitoredProject(
      google::monitoring::metricsscope::v1::
          ListMetricsScopesByMonitoredProjectRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateMonitoredProject(
      google::monitoring::metricsscope::v1::
          CreateMonitoredProjectRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteMonitoredProject(
      google::monitoring::metricsscope::v1::
          DeleteMonitoredProjectRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<MetricsScopesConnectionIdempotencyPolicy>
MakeDefaultMetricsScopesConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultMetricsScopesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google
