// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/metricsscope/v1/metrics_scopes.proto

#include "google/cloud/monitoring/metrics_scopes_connection.h"
#include "google/cloud/monitoring/internal/metrics_scopes_connection_impl.h"
#include "google/cloud/monitoring/internal/metrics_scopes_option_defaults.h"
#include "google/cloud/monitoring/internal/metrics_scopes_stub_factory.h"
#include "google/cloud/monitoring/metrics_scopes_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetricsScopesConnection::~MetricsScopesConnection() = default;

StatusOr<google::monitoring::metricsscope::v1::MetricsScope>
MetricsScopesConnection::GetMetricsScope(
    google::monitoring::metricsscope::v1::GetMetricsScopeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::monitoring::metricsscope::v1::
             ListMetricsScopesByMonitoredProjectResponse>
MetricsScopesConnection::ListMetricsScopesByMonitoredProject(
    google::monitoring::metricsscope::v1::
        ListMetricsScopesByMonitoredProjectRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::monitoring::metricsscope::v1::MonitoredProject>>
MetricsScopesConnection::CreateMonitoredProject(
    google::monitoring::metricsscope::v1::
        CreateMonitoredProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::monitoring::metricsscope::v1::MonitoredProject>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::monitoring::metricsscope::v1::OperationMetadata>>
MetricsScopesConnection::DeleteMonitoredProject(
    google::monitoring::metricsscope::v1::
        DeleteMonitoredProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::monitoring::metricsscope::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<MetricsScopesConnection> MakeMetricsScopesConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 MetricsScopesPolicyOptionList>(options,
                                                                __func__);
  options =
      monitoring_internal::MetricsScopesDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = monitoring_internal::CreateDefaultMetricsScopesStub(
      background->cq(), options);
  return std::make_shared<monitoring_internal::MetricsScopesConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<monitoring::MetricsScopesConnection>
MakeMetricsScopesConnection(std::shared_ptr<MetricsScopesStub> stub,
                            Options options) {
  options = MetricsScopesDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<monitoring_internal::MetricsScopesConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
