// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/metric_service.proto

#include "google/cloud/monitoring/metric_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

MetricServiceConnectionIdempotencyPolicy::
    ~MetricServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultMetricServiceConnectionIdempotencyPolicy
    : public MetricServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultMetricServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<MetricServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultMetricServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListMonitoredResourceDescriptors(
      google::monitoring::v3::ListMonitoredResourceDescriptorsRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetMonitoredResourceDescriptor(
      google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListMetricDescriptors(
      google::monitoring::v3::ListMetricDescriptorsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetMetricDescriptor(
      google::monitoring::v3::GetMetricDescriptorRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateMetricDescriptor(
      google::monitoring::v3::CreateMetricDescriptorRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteMetricDescriptor(
      google::monitoring::v3::DeleteMetricDescriptorRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListTimeSeries(
      google::monitoring::v3::ListTimeSeriesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateTimeSeries(
      google::monitoring::v3::CreateTimeSeriesRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CreateServiceTimeSeries(
      google::monitoring::v3::CreateTimeSeriesRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<MetricServiceConnectionIdempotencyPolicy>
MakeDefaultMetricServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultMetricServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring
}  // namespace cloud
}  // namespace google
