// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#include "google/cloud/monitoring/internal/service_monitoring_connection_impl.h"
#include "google/cloud/monitoring/internal/service_monitoring_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceMonitoringServiceConnectionImpl::ServiceMonitoringServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_internal::ServiceMonitoringServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          monitoring_internal::ServiceMonitoringServiceDefaultOptions(
              ServiceMonitoringServiceConnection::options()))) {}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::CreateService(
    google::monitoring::v3::CreateServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateServiceRequest const& request) {
        return stub_->CreateService(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::GetService(
    google::monitoring::v3::GetServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetServiceRequest const& request) {
        return stub_->GetService(context, request);
      },
      request, __func__);
}

StreamRange<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::ListServices(
    google::monitoring::v3::ListServicesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<monitoring::ServiceMonitoringServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListServices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::Service>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::monitoring::v3::ListServicesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::monitoring::v3::ListServicesRequest const& request) {
              return stub->ListServices(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::ListServicesResponse r) {
        std::vector<google::monitoring::v3::Service> result(
            r.services().size());
        auto& messages = *r.mutable_services();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceConnectionImpl::UpdateService(
    google::monitoring::v3::UpdateServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateServiceRequest const& request) {
        return stub_->UpdateService(context, request);
      },
      request, __func__);
}

Status ServiceMonitoringServiceConnectionImpl::DeleteService(
    google::monitoring::v3::DeleteServiceRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteService(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteServiceRequest const& request) {
        return stub_->DeleteService(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::CreateServiceLevelObjective(
    google::monitoring::v3::CreateServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateServiceLevelObjectiveRequest const&
                 request) {
        return stub_->CreateServiceLevelObjective(context, request);
      },
      request, __func__);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::GetServiceLevelObjective(
    google::monitoring::v3::GetServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::GetServiceLevelObjectiveRequest const&
                 request) {
        return stub_->GetServiceLevelObjective(context, request);
      },
      request, __func__);
}

StreamRange<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::ListServiceLevelObjectives(
    google::monitoring::v3::ListServiceLevelObjectivesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry =
      std::shared_ptr<monitoring::ServiceMonitoringServiceRetryPolicy const>(
          retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListServiceLevelObjectives(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::ServiceLevelObjective>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name](
          google::monitoring::v3::ListServiceLevelObjectivesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::monitoring::v3::ListServiceLevelObjectivesRequest const&
                    request) {
              return stub->ListServiceLevelObjectives(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::ListServiceLevelObjectivesResponse r) {
        std::vector<google::monitoring::v3::ServiceLevelObjective> result(
            r.service_level_objectives().size());
        auto& messages = *r.mutable_service_level_objectives();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceConnectionImpl::UpdateServiceLevelObjective(
    google::monitoring::v3::UpdateServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::UpdateServiceLevelObjectiveRequest const&
                 request) {
        return stub_->UpdateServiceLevelObjective(context, request);
      },
      request, __func__);
}

Status ServiceMonitoringServiceConnectionImpl::DeleteServiceLevelObjective(
    google::monitoring::v3::DeleteServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteServiceLevelObjective(request),
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteServiceLevelObjectiveRequest const&
                 request) {
        return stub_->DeleteServiceLevelObjective(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
