// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/query_service.proto

#include "google/cloud/monitoring/internal/query_connection_impl.h"
#include "google/cloud/monitoring/internal/query_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

QueryServiceConnectionImpl::QueryServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_internal::QueryServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), monitoring_internal::QueryServiceDefaultOptions(
                                  QueryServiceConnection::options()))) {}

StreamRange<google::monitoring::v3::TimeSeriesData>
QueryServiceConnectionImpl::QueryTimeSeries(
    google::monitoring::v3::QueryTimeSeriesRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<monitoring::QueryServiceRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->QueryTimeSeries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::TimeSeriesData>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::monitoring::v3::QueryTimeSeriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::monitoring::v3::QueryTimeSeriesRequest const& request) {
              return stub->QueryTimeSeries(context, request);
            },
            r, function_name);
      },
      [](google::monitoring::v3::QueryTimeSeriesResponse r) {
        std::vector<google::monitoring::v3::TimeSeriesData> result(
            r.time_series_data().size());
        auto& messages = *r.mutable_time_series_data();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_internal
}  // namespace cloud
}  // namespace google
